<?php 
include 'datos_sistema.php';

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo $titulo_pagina_empresa;?></title>

    <!-- Favicon -->
    <link rel="shortcut icon" href="icono_logo_indap.jpg">

    <!-- page css -->

    <!-- Core css -->
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/app.min.css" rel="stylesheet">

</head>

<body>
    <div class="app">
        <div class="layout">
            <!-- Header START -->
            <?php 
            include 'menu_vector.php';
            ?>
            
            <!-- Side Nav END -->

            <!-- Page Container START -->
            <div class="page-container">
                

                <!-- Content Wrapper START -->
                <div class="main-content">
                    <div class="container mt-5">
                        <h2 class="text-center">Registro del Postulante</h2>
                        <form id="wizard-form">
                            <!-- Sección 1: Identificación del Postulante -->
                            <div class="wizard-step">
                                <h4 class="text-center">1. Identificación del Postulante</h4>
                                <div class="row justify-content-center">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label for="nombre" class="form-label">Nombre y Apellidos</label>
                                            <input type="text" class="form-control" id="nombre" required>
                                        </div>
                                        <div class="mb-3">
                                            <label for="genero" class="form-label">Género</label>
                                            <select class="form-control" id="genero" required>
                                                <option value="">Seleccione...</option>
                                                <option value="Masculino">Masculino</option>
                                                <option value="Femenino">Femenino</option>
                                                <option value="Otro">Otro</option>
                                            </select>
                                        </div>
                                        <div class="mb-3">
                                            <label for="rut" class="form-label">RUT</label>
                                            <input type="text" class="form-control" id="rut" required>
                                        </div>
                                        <div class="mb-3">
                                            <label for="telefono" class="form-label">Teléfono</label>
                                            <input type="text" class="form-control" id="telefono" required>
                                        </div>
                                        <div class="mb-3">
                                            <label for="agencia" class="form-label">Agencia de Área</label>
                                            <input type="text" class="form-control" id="agencia" required>
                                        </div>
                                        <button type="button" class="btn btn-primary next">Siguiente</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    <div class="wizard-step">
                        <h4 class="text-center">2. Identificación del Predio</h4>
                        <div class="row justify-content-center">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="rol_predio" class="form-label">Rol del Predio</label>
                                    <input type="text" class="form-control" id="rol_predio" required>
                                </div>
                                <div class="mb-3">
                                    <label for="nombre_predio" class="form-label">Nombre del Predio</label>
                                    <input type="text" class="form-control" id="nombre_predio" required>
                                </div>
                                <div class="mb-3">
                                    <label for="comuna_predio" class="form-label">Comuna del Predio</label>
                                    <input type="text" class="form-control" id="comuna_predio" required>
                                </div>
                                <div class="mb-3">
                                    <label for="sector_predio" class="form-label">Sector del Predio</label>
                                    <input type="text" class="form-control" id="sector_predio" required>
                                </div>
                                <div class="mb-3">
                                    <label for="tenencia_predio" class="form-label">Tenencia del Predio</label>
                                    <select class="form-control" id="tenencia_predio" required>
                                        <option value="">Seleccione...</option>
                                        <option value="Propio">Propio</option>
                                        <option value="Arrendado">Arrendado</option>
                                        <option value="Compartido">Compartido</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="superficie_total" class="form-label">Superficie Total del predio (Hectáreas)</label>
                                    <input type="number" class="form-control" id="superficie_total" required>
                                </div>
                                <div class="mb-3">
                                    <label for="superficie_agropecuaria" class="form-label">Superficie Uso Agropecuario (Hectáreas)</label>
                                    <input type="number" class="form-control" id="superficie_agropecuaria" required>
                                </div>
                                <button type="button" class="btn btn-secondary prev">Anterior</button>
                                <button type="button" class="btn btn-primary next">Siguiente</button>
                            </div>
                        </div>
                    </div>

                    <div class="wizard-step">
                        <h4 class="text-center">3. Participación en Programas de Fomento productivo de INDAP y/o ganaderos</h4>
                        <div class="row justify-content-center">
                            <div class="col-md-6">
                                <label class="form-label">Seleccione Programa(s)</label>
                                <div class="mb-3">
                                    <div class="form-check d-flex align-items-center" style="margin-bottom: 10px;">
                                        <input class="form-check-input" type="checkbox" name="programas[]" value="SAT" id="sat" style="width: 22px; height: 22px; margin-right: 10px;">
                                        <label class="form-check-label fw-bold" for="sat" style="text-transform: uppercase;">SAT</label>
                                    </div>
                                    <div class="form-check d-flex align-items-center" style="margin-bottom: 10px;">
                                        <input class="form-check-input" type="checkbox" name="programas[]" value="Riego Asociativo" id="riego" style="width: 22px; height: 22px; margin-right: 10px;">
                                        <label class="form-check-label fw-bold" for="riego" style="text-transform: uppercase;">Riego Asociativo</label>
                                    </div>
                                    <div class="form-check d-flex align-items-center" style="margin-bottom: 10px;">
                                        <input class="form-check-input" type="checkbox" name="programas[]" value="PRODESAL" id="prodesal" style="width: 22px; height: 22px; margin-right: 10px;">
                                        <label class="form-check-label fw-bold" for="prodesal" style="text-transform: uppercase;">PRODESAL</label>
                                    </div>
                                    <div class="form-check d-flex align-items-center" style="margin-bottom: 10px;">
                                        <input class="form-check-input" type="checkbox" name="programas[]" value="Cultivos Tradicionales" id="cultivos" style="width: 22px; height: 22px; margin-right: 10px;">
                                        <label class="form-check-label fw-bold" for="cultivos" style="text-transform: uppercase;">Cultivos Tradicionales</label>
                                    </div>
                                    <div class="form-check d-flex align-items-center" style="margin-bottom: 10px;">
                                        <input class="form-check-input" type="checkbox" name="programas[]" value="TAS" id="tas" style="width: 22px; height: 22px; margin-right: 10px;">
                                        <label class="form-check-label fw-bold" for="tas" style="text-transform: uppercase;">TAS</label>
                                    </div>
                                    <div class="form-check d-flex align-items-center" style="margin-bottom: 10px;">
                                        <input class="form-check-input" type="checkbox" name="programas[]" value="PDTI" id="pdti" style="width: 22px; height: 22px; margin-right: 10px;">
                                        <label class="form-check-label fw-bold" for="pdti" style="text-transform: uppercase;">PDTI</label>
                                    </div>
                                    <div class="form-check d-flex align-items-center" style="margin-bottom: 10px;">
                                        <input class="form-check-input" type="checkbox" name="programas[]" value="Alianzas Productivas" id="alianzas" style="width: 22px; height: 22px; margin-right: 10px;">
                                        <label class="form-check-label fw-bold" for="alianzas" style="text-transform: uppercase;">Alianzas Productivas</label>
                                    </div>
                                    <div class="form-check d-flex align-items-center" style="margin-bottom: 10px;">
                                        <input class="form-check-input" type="checkbox" name="programas[]" value="PDI" id="pdi" style="width: 22px; height: 22px; margin-right: 10px;">
                                        <label class="form-check-label fw-bold" for="pdi" style="text-transform: uppercase;">PDI</label>
                                    </div>
                                    <div class="form-check d-flex align-items-center" style="margin-bottom: 10px;">
                                        <input class="form-check-input" type="checkbox" name="programas[]" value="SIRSD-S" id="sirsd" style="width: 22px; height: 22px; margin-right: 10px;">
                                        <label class="form-check-label fw-bold" for="sirsd" style="text-transform: uppercase;">SIRSD-S</label>
                                    </div>
                                    <div class="form-check d-flex align-items-center" style="margin-bottom: 10px;">
                                        <input class="form-check-input" type="checkbox" name="programas[]" value="Sin Asesoría Actualmente" id="sin_asesoria" style="width: 22px; height: 22px; margin-right: 10px;">
                                        <label class="form-check-label fw-bold" for="sin_asesoria" style="text-transform: uppercase;">Sin Asesoría Actualmente</label>
                                    </div>
                                </div>
                                <button type="button" class="btn btn-secondary prev">Anterior</button>
                                <button type="button" class="btn btn-primary next">Siguiente</button>
                            </div>
                        </div>
                    </div>

                    <div class="wizard-step">
    <h4 class="text-center">4. Plan de Establecimiento</h4>
    <p class="text-center">Uno por cada predio, potrero o sector a establecer.</p>
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="mb-3">
                <label for="nombre_potrero" class="form-label">Nombre del Potrero</label>
                <input type="text" class="form-control" id="nombre_potrero" required>
            </div>
            <div class="mb-3">
                <label for="tipo_practica" class="form-label">Tipo de Práctica a Establecer</label>
                <select class="form-control" id="tipo_practica" required>
                    <option value="">Seleccione...</option>
                    <option value="Cultivos">Cultivos</option>
                    <option value="Ganadería">Ganadería</option>
                    <option value="Forestal">Forestal</option>
                </select>
            </div>
            <div class="mb-3">
                <label for="superficie_intervenir" class="form-label">Superficie a Intervenir (Hectáreas)</label>
                <input type="number" class="form-control" id="superficie_intervenir" required>
            </div>
            <div class="mb-3">
                <label for="fecha_inicio" class="form-label">Fecha Inicio Ejecución Práctica</label>
                <input type="date" class="form-control" id="fecha_inicio" required>
            </div>
            <div class="mb-3">
                <label for="fecha_termino" class="form-label">Fecha Término Ejecución Práctica</label>
                <input type="date" class="form-control" id="fecha_termino" required>
            </div>
            <div class="mb-3">
                <label for="datum" class="form-label">Datum</label>
                <input type="text" class="form-control" id="datum" required>
            </div>
            <div class="mb-3">
                <label for="coordenada_este" class="form-label">Coordenada Este (potrero a intervenir)</label>
                <input type="text" class="form-control" id="coordenada_este" required>
            </div>
            <div class="mb-3">
                <label for="coordenada_norte" class="form-label">Coordenada Norte (potrero a intervenir)</label>
                <input type="text" class="form-control" id="coordenada_norte" required>
            </div>
            <div class="mb-3">
                <label for="huso" class="form-label">Huso</label>
                <input type="text" class="form-control" id="huso" required>
            </div>
            <div class="mb-3">
                <label for="inversion_bruto" class="form-label">Inversión Bruto por Potrero (Con IVA)</label>
                <input type="number" class="form-control" id="inversion_bruto" required>
            </div>
            <div class="mb-3">
                <label for="incentivo_inversion" class="form-label">Incentivo Inversión Solicitado por Potrero(Con IVA)</label>
                <input type="number" class="form-control" id="incentivo_inversion" required>
            </div>
            <div class="mb-3">
                <label for="incentivo_formulacion" class="form-label">Incentivo a la Formulación del Plan de establecimiento</label>
                <input type="number" class="form-control" id="incentivo_formulacion" required>
            </div>
            <div class="mb-3">
                <label for="monto_aporte_propio" class="form-label">Monto Aporte Propio por Potrero (Con IVA)</label>
                <input type="number" class="form-control" id="monto_aporte_propio" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Datos para georreferenciación</label>
                <p>Se solicitará archivo KML o dibujar el polígono en plataforma digital para la postulación del programa.</p>
            </div>
            <button type="button" class="btn btn-secondary prev">Anterior</button>
            <button type="submit" class="btn btn-success">Enviar Formulario</button>
        </div>
    </div>
</div>




                    <hr><hr><br><br>
                    
                   
                </div>
                <!-- Content Wrapper END -->

                <!-- Footer START -->
                <footer class="footer">
                    <div class="footer-content justify-content-between">
                        <p class="m-b-0"><?php echo $footer_empresa;  ?></p>
                        <!--<span>
                            <a href="" class="text-gray m-r-15">Term &amp; Conditions</a>
                            <a href="" class="text-gray">Privacy &amp; Policy</a>
                        </span>-->
                    </div>
                </footer>
                <!-- Footer END -->

            </div>
            <!-- Page Container END -->

            <!-- Search Start-->
            <div class="modal modal-left fade search" id="search-drawer">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header justify-content-between align-items-center">
                            <h5 class="modal-title">Search</h5>
                            <button type="button" class="close" data-dismiss="modal">
                                <i class="anticon anticon-close"></i>
                            </button>
                        </div>
                        <div class="modal-body scrollable">
                            <div class="input-affix">
                                <i class="prefix-icon anticon anticon-search"></i>
                                <input type="text" class="form-control" placeholder="Search">
                            </div>
                            <div class="m-t-30">
                                <h5 class="m-b-20">Files</h5>
                                <div class="d-flex m-b-30">
                                    <div class="avatar avatar-cyan avatar-icon">
                                        <i class="anticon anticon-file-excel"></i>
                                    </div>
                                    <div class="m-l-15">
                                        <a href="javascript:void(0);" class="text-dark m-b-0 font-weight-semibold">Quater Report.exl</a>
                                        <p class="m-b-0 text-muted font-size-13">by Finance</p>
                                    </div>
                                </div>
                                <div class="d-flex m-b-30">
                                    <div class="avatar avatar-blue avatar-icon">
                                        <i class="anticon anticon-file-word"></i>
                                    </div>
                                    <div class="m-l-15">
                                        <a href="javascript:void(0);" class="text-dark m-b-0 font-weight-semibold">Documentaion.docx</a>
                                        <p class="m-b-0 text-muted font-size-13">by Developers</p>
                                    </div>
                                </div>
                                <div class="d-flex m-b-30">
                                    <div class="avatar avatar-purple avatar-icon">
                                        <i class="anticon anticon-file-text"></i>
                                    </div>
                                    <div class="m-l-15">
                                        <a href="javascript:void(0);" class="text-dark m-b-0 font-weight-semibold">Recipe.txt</a>
                                        <p class="m-b-0 text-muted font-size-13">by The Chef</p>
                                    </div>
                                </div>
                                <div class="d-flex m-b-30">
                                    <div class="avatar avatar-red avatar-icon">
                                        <i class="anticon anticon-file-pdf"></i>
                                    </div>
                                    <div class="m-l-15">
                                        <a href="javascript:void(0);" class="text-dark m-b-0 font-weight-semibold">Project Requirement.pdf</a>
                                        <p class="m-b-0 text-muted font-size-13">by Project Manager</p>
                                    </div>
                                </div>
                            </div>
                            <div class="m-t-30">
                                <h5 class="m-b-20">Members</h5>
                                <div class="d-flex m-b-30">
                                    <div class="avatar avatar-image">
                                        <img src="assets/images/avatars/thumb-1.jpg" alt="">
                                    </div>
                                    <div class="m-l-15">
                                        <a href="javascript:void(0);" class="text-dark m-b-0 font-weight-semibold">Erin Gonzales</a>
                                        <p class="m-b-0 text-muted font-size-13">UI/UX Designer</p>
                                    </div>
                                </div>
                                <div class="d-flex m-b-30">
                                    <div class="avatar avatar-image">
                                        <img src="assets/images/avatars/thumb-2.jpg" alt="">
                                    </div>
                                    <div class="m-l-15">
                                        <a href="javascript:void(0);" class="text-dark m-b-0 font-weight-semibold">Darryl Day</a>
                                        <p class="m-b-0 text-muted font-size-13">Software Engineer</p>
                                    </div>
                                </div>
                                <div class="d-flex m-b-30">
                                    <div class="avatar avatar-image">
                                        <img src="assets/images/avatars/thumb-3.jpg" alt="">
                                    </div>
                                    <div class="m-l-15">
                                        <a href="javascript:void(0);" class="text-dark m-b-0 font-weight-semibold">Marshall Nichols</a>
                                        <p class="m-b-0 text-muted font-size-13">Data Analyst</p>
                                    </div>
                                </div>
                            </div>   
                            <div class="m-t-30">
                                <h5 class="m-b-20">News</h5> 
                                <div class="d-flex m-b-30">
                                    <div class="avatar avatar-image">
                                        <img src="assets/images/others/img-1.jpg" alt="">
                                    </div>
                                    <div class="m-l-15">
                                        <a href="javascript:void(0);" class="text-dark m-b-0 font-weight-semibold">5 Best Handwriting Fonts</a>
                                        <p class="m-b-0 text-muted font-size-13">
                                            <i class="anticon anticon-clock-circle"></i>
                                            <span class="m-l-5">25 Nov 2018</span>
                                        </p>
                                    </div>
                                </div>
                            </div>    
                        </div>
                    </div>
                </div>
            </div>
            <!-- Search End-->

            <!-- Quick View START -->
            
            <!-- Quick View END -->
        </div>
    </div>

    
    <script type="text/javascript">
        document.addEventListener("DOMContentLoaded", function () {
            let currentStep = 0;
            const steps = document.querySelectorAll(".wizard-step");
            const nextButtons = document.querySelectorAll(".next");
            const prevButtons = document.querySelectorAll(".prev");

            function showStep(stepIndex) {
                steps.forEach((step, index) => {
                    step.style.display = index === stepIndex ? "block" : "none";
                });
            }

            nextButtons.forEach((button, index) => {
                button.addEventListener("click", () => {
                    if (validateStep(index)) {
                        currentStep++;
                        showStep(currentStep);
                    }
                });
            });

            prevButtons.forEach(button => {
                button.addEventListener("click", () => {
                    currentStep--;
                    showStep(currentStep);
                });
            });

            function validateStep(index) {
                let inputs = steps[index].querySelectorAll("input, select");
                let valid = true;
                inputs.forEach(input => {
                    if (!input.value.trim()) {
                        input.classList.add("is-invalid");
                        valid = false;
                    } else {
                        input.classList.remove("is-invalid");
                    }
                });
                return valid;
            }

            showStep(currentStep);
        });
    </script>
    <!-- Core Vendors JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/vendors.min.js"></script>

    <!-- page js -->
    <script src="assets/vendors/jquery-validation/jquery.validate.min.js"></script>
    <script src="assets/js/pages/form-validation.js"></script>

    <!-- Core JS -->
    <script src="assets/js/app.min.js"></script>

    



</body>

</html>