<?php
    include("datos_sistema.php");

    //SQL QUE CAPTURA LOS ACCESORIOS DE USADOS Y NUEVOS, PARA LISTARLOS EN EL CAMPO "PRODUCTO"
    $sql_accesorios = "
        SELECT id_producto, id_cod_producto, accesorio, n_serie
        FROM productos_accesorios_usados
        WHERE id_cod_producto IN (
            SELECT id_cod_producto
            FROM productos_arriendo
            WHERE estado_producto <> 'Eliminado' AND cantidad > 0
            UNION
            SELECT id_cod_producto
            FROM productos
            WHERE estado_producto <> 'Eliminado' AND cantidad > 0
        )
        UNION
        SELECT id_producto, id_cod_producto, accesorio, n_serie
        FROM productos_accesorios
        WHERE id_cod_producto IN (
            SELECT id_cod_producto
            FROM productos_arriendo
            WHERE estado_producto <> 'Eliminado' AND cantidad > 0
            UNION
            SELECT id_cod_producto
            FROM productos
            WHERE estado_producto <> 'Eliminado' AND cantidad > 0
        )
        ORDER BY id_producto ASC, accesorio ASC
    ";
    $query_accesorios = mysqli_query($con, $sql_accesorios);

    //DOS TABLAS PARA UN SOLO DATALIST.
    $sql_producto = "
    SELECT 
        pa.id_producto_arriendo AS id_producto,
        pa.id_cod_producto,
        pa.nombre_producto,
        pa.cantidad,
        pa.estado_producto,
        pa.tipo_producto,
        psa.n_serie,
        pa.precio_venta
    FROM 
        productos_arriendo pa
    LEFT JOIN 
        productos_series_arriendo psa ON pa.id_producto_arriendo = psa.id_producto
    WHERE 
        pa.estado_producto <> 'Eliminado' 
        AND pa.cantidad > 0

    UNION ALL

    SELECT 
        p.id_producto,
        p.id_cod_producto,
        p.nombre_producto,
        p.cantidad,
        p.estado_producto,
        p.tipo_producto,
        ps.n_serie,
        p.precio_venta
    FROM 
        productos p
    LEFT JOIN 
        productos_series ps ON p.id_producto = ps.id_producto
    WHERE 
        p.estado_producto <> 'Eliminado' 
        AND p.cantidad > 0

    ORDER BY 
        nombre_producto ASC
";
$query_producto = mysqli_query($con, $sql_producto);



    //CONTINUA LA LOGICA SQL ANTERIOR. PARA DIFERENCIAR LOS PRODS NUEVOS Y USADOS, POR id_producto, id_cod_producto y nombre_producto
    $sql_idcodprod = "
    SELECT 
        pa.id_producto_arriendo AS id_producto,
        pa.id_cod_producto,
        pa.nombre_producto,
        pa.cantidad,
        pa.estado_producto,
        pa.precio_venta,
        pa.categoria,
        pa.modelo,
        psa.n_serie
    FROM 
        productos_arriendo pa
    LEFT JOIN 
        productos_series_arriendo psa ON pa.id_producto_arriendo = psa.id_producto
    WHERE 
        pa.estado_producto <> 'Eliminado' 
        AND pa.cantidad > 0

    UNION ALL

    SELECT 
        p.id_producto,
        p.id_cod_producto,
        p.nombre_producto,
        p.cantidad,
        p.estado_producto,
        p.precio_venta,
        p.categoria,
        p.modelo,
        ps.n_serie
    FROM 
        productos p
    LEFT JOIN 
        productos_series ps ON p.id_producto = ps.id_producto
    WHERE 
        p.estado_producto <> 'Eliminado' 
        AND p.cantidad > 0

    ORDER BY 
        nombre_producto ASC
";
$query_idcodprod = mysqli_query($con, $sql_idcodprod);


    //PRODUCTOS DE 2 TABLAS , NUEVOS Y ARRIENDO PARA COMPARACION SI NO EXISTE.
    $sql_producto_comparacion = "
    SELECT 
        pa.id_producto_arriendo AS id_producto,
        pa.id_cod_producto,
        pa.nombre_producto,
        pa.cantidad,
        pa.estado_producto,
        pa.precio_venta,
        pa.categoria,
        pa.modelo,
        psa.n_serie
    FROM 
        productos_arriendo pa
    LEFT JOIN 
        productos_series_arriendo psa ON pa.id_producto_arriendo = psa.id_producto
    WHERE 
        pa.estado_producto <> 'Eliminado' 
        AND pa.cantidad > 0

    UNION ALL

    SELECT 
        p.id_producto,
        p.id_cod_producto,
        p.nombre_producto,
        p.cantidad,
        p.estado_producto,
        p.precio_venta,
        p.categoria,
        p.modelo,
        ps.n_serie
    FROM 
        productos p
    LEFT JOIN 
        productos_series ps ON p.id_producto = ps.id_producto
    WHERE 
        p.estado_producto <> 'Eliminado' 
        AND p.cantidad > 0

    ORDER BY 
        nombre_producto ASC
";
$queryproductos_comparacion = mysqli_query($con, $sql_producto_comparacion);


    //QUERY PARA LOS USUARIOS VENDEDOR SELECT.
    $sql_vendedor = "SELECT * FROM usuario WHERE rol = 'Vendedor' AND estado = 'Activo' or rol = 'Administrador' AND estado = 'Activo'";
    $queryvendedor = mysqli_query($con, $sql_vendedor);    

    //PARA LISTAR ID,NOMBRE APELLIDO Y RUT EN CAMPO INPUT CLIENTE.
    $sql_cliente = "SELECT * FROM cliente WHERE estado = 'Activo' ORDER BY nombre DESC";
    $query_cliente = mysqli_query($con, $sql_cliente);
?>

<!doctype html>
<html lang="es">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- loader-->
	  <link href="assets/css/pace.min.css" rel="stylesheet" />
	  <script src="assets/js/pace.min.js"></script>

    <!--plugins-->
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="assets/plugins/input-tags/css/tagsinput.css" rel="stylesheet" />

    <!-- CSS Files -->
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">

    <!--Theme Styles-->
    <link href="assets/css/dark-theme.css" rel="stylesheet" />
    <link href="assets/css/semi-dark.css" rel="stylesheet" />
    <link href="assets/css/header-colors.css" rel="stylesheet" />
    <!-- CSS de SweetAlert2 PARA LA ALERTA ANIMADA CADA VEZ QUE SE REALIZA EDITAR, ELIMINAR ETC. -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.18/dist/sweetalert2.min.css">
    <!-- JS de SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.18/dist/sweetalert2.all.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <title>GESTIÓN NEOTOP</title>
    <link rel="icon" type="image/png" href="icono.png">
  </head>
  <body>
    
<style>
        /* Estilo para el contenedor del label y el input */
        .form-label-inside {
          position: relative;
        }

        /* Estilo para el label */
        .form-label-inside label {
          position: absolute;
          top: 0.3rem; /* Ajusta el espaciado vertical del label */
          left: 1rem; /* Ajusta el espaciado horizontal del label */
          pointer-events: none;
          color: #6c757d; /* Color del texto del label */
          transition: 0.2s; /* Transición para suavizar el efecto al hacer foco en el input */
        }

        /* Estilo para el input */
        .form-label-inside input {
          padding: 1.2rem 1rem 0.3rem; /* Espacio para el label y contenido del input. el 0.3rem es el espacio de abajo a arriba. */
          height: 3.0rem; /* Ajusta la altura del input para lograr el efecto deseado */
          margin-bottom: 0.3rem;
        }
        /* Estilo para el input */
        .form-label-inside select {
           /* Espacio para el label y contenido del input. el 0.3rem es el espacio de abajo a arriba. */
          height: 3.0rem; /* Ajusta la altura del input para lograr el efecto deseado */
          margin-bottom: 0.3rem;
          top: 0.3rem;
          left: 1rem;
          padding: 0.7rem 1rem; /* Ajusta el padding para alinear verticalmente el texto */
        }

        /* Estilo para el input cuando está enfocado o tiene contenido */
        .form-label-inside input:focus + label,
        .form-label-inside input:not(:placeholder-shown) + label {
          top: 0.15rem; /* Ajusta el espaciado vertical del label cuando está enfocado o tiene contenido */
          font-size: 0.90rem; /* Tamaño de fuente reducido para el label cuando está enfocado o tiene contenido */
        }
    </style>
    <style>
        /* Estilo para el contenedor de los divs */
        .div-container {
            margin-bottom: 2px;
        }

        /* Estilo para los divs que contienen los inputs */
        .input-div {
            margin-right: 1;
            margin-left: 1;
            margin-bottom: 2px;
        }
    </style>
    <style>
  .campo_required {
    border: 2px solid red;
    border-radius: 5px;
    padding: 8px;
    outline: none;
    box-shadow: 0 0 5px rgba(255, 0, 0, 0.5);
  }

  .campo_required:focus {
    box-shadow: 0 0 10px rgba(255, 0, 0, 0.8);
  }
</style>
    <script type="text/javascript">
        function ocultar_apellido() {
            const tipo_cliente2 = document.getElementById("tipo_cliente").value;
            const apellido2 = document.getElementById("apellido_paterno").value;
            if (tipo_cliente2 == "Empresa") {
                //document.getElementById("apellido").hidden = true;
                document.getElementById("apellido_paterno").disabled = true;
                document.getElementById("divapellido").hidden = true;
                document.getElementById("apellido_paterno").value = "";
                document.getElementById("contacto_responsable").disabled = false;
                document.getElementById("divcontacto").hidden = false;
            } else if (tipo_cliente2 == "Natural"){
                document.getElementById("apellido_paterno").disabled = false;
                document.getElementById("divapellido").hidden = false;
                document.getElementById("contacto_responsable").disabled = true;
                document.getElementById("divcontacto").hidden = true;
                document.getElementById("contacto_responsable").value = "";
            }
        }
    </script>
    <script type="text/javascript">
        function ocultar_despacho() {
            const monto_despacho = document.getElementById("monto_despacho").value;
            const despacho = document.getElementById("despacho").value;
            const direccion_despacho = document.getElementById("direccion_despacho").value;
            const label_despacho = document.getElementById("label_despacho").value;
            if (despacho == "No") {
                document.getElementById("monto_despacho").hidden = true;
                document.getElementById("label_despacho").hidden = true;
                document.getElementById("monto_despacho").value = "0";

                document.getElementById("direccion_despacho").hidden = true;
                document.getElementById("direccion_despacho").value = "No";
                document.getElementById("label_direccion").hidden = true;
                document.getElementById("div_direccion").hidden = true;
            } else if (despacho == "Si"){
                document.getElementById("monto_despacho").hidden = false;
                document.getElementById("label_despacho").hidden = false;
                document.getElementById("monto_despacho").value = "0";

                document.getElementById("direccion_despacho").hidden = false;
                document.getElementById("label_direccion").hidden = false;
                document.getElementById("direccion_despacho").value = "";
                document.getElementById("div_direccion").hidden = false;
            }
        }
        function calculo_despacho() {
            const monto_despacho2 = document.getElementById("monto_despacho");
            let valor = monto_despacho2.value.replace(/[.]/g, '') || '0'; 
            monto_despacho2.value = valor.replace(/^0+(?=\d)/, '').replace(/\B(?=(\d{3})+(?!\d))/g, '.');
        }
    </script>
    <script type="text/javascript">
        //ESCRIPT DE RIAL EL UNICO QUE FUNCIONÓ SIN PROBLEMAS.
        function confirmarlo(event) {  
            event.preventDefault();      
              const letrasRegex = /^[a-zA-Z\s]+$/;
              const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
              var cliente1 = document.getElementById("cliente");
              var ver_o_registrar = document.getElementById("ver_o_registrar");
              var usuario = document.getElementById("usuario").value;
              var tipo_pago = document.getElementById("tipo_pago").value;
              var productos = document.getElementsByClassName("repuesto_pieza[]"); //input de producto
              var cantidad = document.getElementsByClassName("cantidad[]"); //input cantidad
              var valor = document.getElementsByClassName("valor[]");
              var alerta_noencontrado = document.getElementsByClassName("alerta_noencontrado[]");
              var despacho3 = document.getElementById("despacho");  
              var valido_hasta = document.getElementById("valido_hasta");  
              var direccion_despacho = document.getElementById("direccion_despacho");  
              var n_repetido1 = 0;
              var prod_no_valido = 0;
              var arraycodsprods1; 
              var datalist_rut = document.getElementById("list_clientes").options;
              var n_repetido = 0;
              for (var i = 0; i < datalist_rut.length; i++) {   
                    if (datalist_rut[i].value == cliente1.value) { 
                        n_repetido = n_repetido + 1;                        
                    }                      
              }
              if (cliente1.value == "" || n_repetido == 0) {
                //si n_repetido es 0 entonces no se seleccionó ningún cliente, debe ser 1 para que pueda pasar.
                Swal.fire({
                  title: "Error",
                  text: "Por favor seleccione un 'Cliente' válido",
                  icon: "warning",
                  confirmButtonColor: "#2a3042",
                  confirmButtonText: "Aceptar"
                });
                return false;
              }
              if (usuario == "") {
                Swal.fire({
                  title: "Error",
                  text: "Por favor seleccione un Usuario.",
                  icon: "warning",
                  confirmButtonColor: "#2a3042",
                  confirmButtonText: "Aceptar"                  
                });
                return false;
              }
              if (valido_hasta.value == "") {
                Swal.fire({
                  title: "Error",
                  text: "Por favor completa el campo Válido Hasta.",
                  icon: "warning",
                  confirmButtonColor: "#2a3042",
                  confirmButtonText: "Aceptar"                  
                });
                return false;
              }
              
              for (var i = 0; i < productos.length; i++) {                       
                    if (productos[i].value == "") { 
                        n_repetido1 = n_repetido1 + 1;   
                    }                                
                    if (n_repetido1 > 0 || alerta_noencontrado[i].hidden == false) {
                        Swal.fire({
                          title: "Error",
                          text: "Por favor complete los campos de los Producto(s) faltantes.",
                          icon: "warning",
                          confirmButtonColor: "#2a3042",
                          confirmButtonText: "Aceptar"                          
                        });
                        return false;
                    }                    
              }
              var n1 = 0;
              for (var i = 0; i < cantidad.length; i++) {                       
                    if (cantidad[i].value == "" || cantidad[i].value == 0 || cantidad[i].value < 0) { 
                        n1 = n1 + 1;   
                    }                                
                    if (n1 > 0) {
                        Swal.fire({
                          title: "Error",
                          text: "Por favor complete los campos de Cantidad faltantes.",
                          icon: "warning",
                          confirmButtonColor: "#2a3042",
                          confirmButtonText: "Aceptar"                          
                        });
                        return false;
                    }
              }
              var n1v = 0;
              for (var i = 0; i < valor.length; i++) {                       
                    if (valor[i].value == "" || valor[i].value == 0 || valor[i].value < 0) { 
                        n1v = n1v + 1;   
                    }                                
                    if (n1v > 0) {
                        Swal.fire({
                          title: "Error",
                          text: "El/Los campos Valor de los productos no puede ser 0 o negativo.",
                          icon: "warning",
                          confirmButtonColor: "#2a3042",
                          confirmButtonText: "Aceptar"                          
                        });
                        return false;
                    }
              }
              if (ver_o_registrar.value == "") {
                Swal.fire({
                  title: "Error",
                  text: "Por favor seleccione si desea Ver o Registrar la cotización",
                  icon: "warning",
                  confirmButtonColor: "#2a3042",
                  confirmButtonText: "Aceptar"                  
                });
                return false;
              }
              if (despacho3.value == "") {
                Swal.fire({
                  title: "Error",
                  text: "Por favor seleccione una opción para 'Despacho'",
                  icon: "warning",
                  confirmButtonColor: "#2a3042",
                  confirmButtonText: "Aceptar"                  
                });
                return false;
              }

              if (despacho3.value == "Si") {
                if (direccion_despacho.value == "") {
                    Swal.fire({
                      title: "Error",
                      text: "Por favor ingrese la dirección de Despacho",
                      icon: "warning",
                      confirmButtonColor: "#2a3042",
                      confirmButtonText: "Aceptar"                  
                    });
                    return false;
                }
                
              }
              if (tipo_pago == "") {
                Swal.fire({
                  title: "Error",
                  text: "Por favor seleccione un Tipo de Pago.",
                  icon: "warning",
                  confirmButtonColor: "#2a3042",
                  confirmButtonText: "Aceptar"                  
                });
                return false;
              }
              if (ver_o_registrar.value == "Ver") {
                    Swal.fire({
                        title: 'Confirmar Acción',
                        text: "¿Estás seguro de que deseas solamente ver el documento PDF?. Los datos no se registrarán en el sistema.",
                        icon: 'question',
                        showCancelButton: true,
                        confirmButtonColor: "#2a3042",
                        cancelButtonColor: '#931A00',
                        confirmButtonText: 'Sí, Visualizar',
                        cancelButtonText: 'Cancelar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Abrir en una nueva pestaña
                            window.open('', 'formtarget');
                            document.clienteform.target = 'formtarget'; // Asigna el target para abrir en la nueva pestaña
                            document.clienteform.submit(); // Envía el formulario
                        }
                    });
              }
              if (ver_o_registrar.value == "Registrar") {
                Swal.fire({
                    title: 'Confirmar registro',   
                    text: "¿Estás segur@ de registrar esta Cotización?",             
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonColor: "#2a3042",
                    cancelButtonColor: '931A00',
                    confirmButtonText: 'Sí, registrar',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.clienteform.target = '_self'; // Restablece el target para abrir en la misma pestaña
                        document.clienteform.submit(); // Envía el formulario
                    }
                })
              }
        }
    </script>
 <!--start wrapper-->
    <div class="wrapper">
       <!--start sidebar -->
    <?php include("menu_vector.php");  ?>
        <!-- start page content wrapper-->
        <div class="page-content-wrapper">
          <!-- start page content-->
         <div class="page-content">
          <!--start breadcrumb-->
          <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
            <div class="breadcrumb-title pe-3">Cotizaciones</div>
            <div class="ps-3">
              <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0 p-0 align-items-center">
                  <li class="breadcrumb-item"><a href="index.php"><ion-icon name="home-outline"></ion-icon></a>
                  </li>
                  <li class="breadcrumb-item active" aria-current="page">Registrar Cotización</li>
                </ol>
              </nav>
            </div>
            <div class="ms-auto">
              
            </div>
          </div>
          <!--end breadcrumb-->

          <div class="card">
            <div class="card-header">
              <h6 class="mb-0">Registrar Nueva Cotización</h6>
            </div>
            <div class="card-body">

              <form class="user" id="clienteform" name="clienteform" action="registro_cotizacion.php" method="POST">
                                          <!-- Cliente (datos relevantes) -->
                                                <datalist name="arreglo_piezas" id="arreglo_piezas" class="col-12 bg-white arreglo_piezas" hidden>
    <?php while ($rowpiezas = mysqli_fetch_assoc($queryproductos_comparacion)) {
        if ($rowpiezas['cantidad'] > 0) {
    ?>
        <option value="<?php echo $rowpiezas['id_cod_producto']." | ".$rowpiezas['nombre_producto']." | ".$rowpiezas['precio_venta']." | ".$rowpiezas['n_serie']; ?>">
            <?php echo $rowpiezas['categoria']." | ".$rowpiezas['modelo']; ?>
        </option>
    <?php } } mysqli_free_result($queryproductos_comparacion); ?>
</datalist>
                                               
                                                <datalist name="accesorios_productos" id="accesorios_prod" class="col-12 bg-white" style="width: 100%;">
                                                    <?php while ($row_acc = mysqli_fetch_assoc($query_accesorios)) { ?>
                                                        <option value="<?php echo $row_acc['id_cod_producto']." | ".$row_acc['accesorio']." | ".$row_acc['n_serie']." | ".$row_acc['id_producto']; ?>"></option>
                                                    <?php } mysqli_free_result($query_accesorios); ?>
                                                </datalist>
                                                <datalist id="list_clientes" class="col-12 bg-white" style="width: 100%;">
                                                      <?php while ($row_cliente = mysqli_fetch_assoc($query_cliente)) {
                                                                    
                                                        ?>
                                                      <option value="<?php 
                                                        if ($row_cliente['nombre'] != "") {
                                                            echo $row_cliente['nombre']." ".$row_cliente['apellido']." | ".$row_cliente['rut'];
                                                        } else {
                                                            echo $row_cliente['razon_social']." | ".$row_cliente['rut'];
                                                        }?>"></option>
                                                      <?php  }mysqli_free_result($query_cliente); ?>
                                                </datalist>
                                            <div class="form-group row div-container">   
                                                <div class="col-sm-3 form-floating form-label-inside input-div">
                                                    <select class="form-control campo_required" id="usuario" style="height: 58px;" name="usuario">
                                                            <option value="">Usuario</option>
                                                            <?php while ($rowtecnico = mysqli_fetch_assoc($queryvendedor)) {
                                                        ?><option value="<?php echo $rowtecnico['id_usuario'];?>"><?php echo $rowtecnico['nombre']." ".$rowtecnico['apellido']." | ".$rowtecnico['rut'];?></option>
                                                        <?php }mysqli_free_result($queryvendedor); ?>
                                                    </select>  
                                                    <label for="usuario" class="col-sm-12">SELECCIONAR USUARIO</label>
                                                </div>
                                                <div class="col-sm-4 form-floating form-row form-label-inside input-div" style="margin-left: 2px;">  
                                                    <input type="text" class="form-control form-row col-10 campo_required" id="cliente" list="list_clientes" name="cliente" placeholder=" ">
                                                    <label for="cliente" class="">Ingrese Cliente por RUT o Nombre</label>
                                                </div>
                                                <div class="col-sm-1" style="margin-left: -22px;">
                                                    <button type="button" class="form-row btn col-sm-2" style="background: #2a3042; height: 55px; width: 55px; color: white;" data-bs-toggle="modal" data-bs-target="#registroCliente">+</button> 
                                                </div> 
                                                <div class="col-sm-2 mb-3 mb-sm-0 form-label-inside input-div" style="margin-left: 20px;">
                                                    <input type="date" class="form-control" id="valido_hasta" name="valido_hasta" style="height: 58px;">
                                                    <label for="valido_hasta" class="col-sm-12 control-label">Válido hasta</label>
                                                </div>
                                                <div class="col-sm-2 form-floating form-label-inside input-div">
                                                    <select class="form-control campo_required" id="servicio" style="height: 58px;" name="servicio">
                                                            <option value="">Servicio</option>
                                                            <option value="Venta">Venta</option>
                                                            <option value="Servicio Técnico">Servicio Técnico</option>
                                                            <option value="Servicio Topográfico">Servicio Topográfico</option>
                                                           
                                                    </select>  
                                                    <label for="servicio" class="col-sm-12">SELECCIONAR SERVICIO</label>
                                                </div>
                                                <div class="col-sm-8" style="margin-top: 10px; margin-bottom: 10px;">
                                                    <textarea type="text" class="form-control" placeholder="Descripción" id="descripcion" name="descripcion"></textarea>  
                                                </div>                                                   
                                            </div>
                                            <div class="newData">

                                            </div>
                                            <div class="form-group row div-container">  
                                                <div class="col-sm-9 form-floating form-label-inside input-div">
                                                                                                    
                                                </div>  
                                                <div class="col-sm-3 form-floating form-label-inside input-div">
                                                    <!-- SERVICIOS DEL COLABORADOR el segundo servicio asiciado select, empezara con id servicios1-->                                                    
                                                    <button type="button" class="btn add-btn" style="background: #2a3042; height: 47px; width: 100%; color: white; margin-bottom: 10px; margin-right: 5px;" data-toggle="modal">Agregar Producto</button>                                               
                                                </div> 
                                                                    
                                            </div>                                              
                                            <div class="form-group row div-container">
                                                <div class="col-sm-2 form-floating form-label-inside input-div">
                                                    <select class="form-control campo_required" onchange="ocultar_despacho()" id="despacho" title="DESPACHO" style="height: 58px;" name="despacho">
                                                        <option value="">Seleccionar</option>
                                                        <option value="Si">Si</option>
                                                        <option value="No">No</option>
                                                    </select>   
                                                    <label for="despacho" class="col-sm-12">DESPACHO</label>
                                                </div>  
                                                <div class="col-sm-1 form-floating form-label-inside input-div">
                                                    <input type="text" value="0" class="form-control campo_required" hidden oninput="calculo_despacho(); calculos_cotizacion();"  id="monto_despacho" name="monto_despacho" placeholder="">
                                                    <label for="monto_despacho" id="label_despacho" hidden class="col-sm-12">MONTO</label>
                                                </div> 
                                                <div class="col-sm-2 form-floating form-label-inside input-div" >
                                                    <select class="form-control campo_required" id="tipo_pago" style="height: 58px;" name="tipo_pago">
                                                        <option value="">Tipo de Pago</option>
                                                        <option value="Efectivo">Efectivo</option>
                                                        <option value="Crédito (30 días)">Crédito (30 días)</option>
                                                        <option value="Crédito (45 días)">Crédito (45 días)</option>
                                                        <option value="Cheque">Cheque</option>
                                                        <option value="Transferencia">Transferencia</option>
                                                        <option value="SUMUP">SUMUP</option>
                                                        <option value="WebPay">WebPay</option>
                                                    </select> 
                                                    <label for="tipo_pago" class="col-sm-12">SELECCIONAR TIPO PAGO</label>
                                                </div>
                                                <div class="col-sm-2 form-floating form-label-inside input-div">
                                                    <input type="text" class="form-control" readonly id="total_descuentos" name="total_descuentos" placeholder="">
                                                    <label for="total_descuentos" class="col-sm-12">TOTAL DESCUENTOS</label>
                                                </div>  
                                                <div class="col-sm-2 form-floating form-label-inside input-div">
                                                    <input type="text" class="form-control" readonly id="subtotal" name="subtotal" placeholder="">
                                                    <label for="subtotal" class="col-sm-12">SUBTOTAL</label>
                                                </div>  
                                                <div class="col-sm-1 form-floating form-label-inside input-div">
                                                    <input type="text" class="form-control" readonly id="iva" name="iva" placeholder="">
                                                    <label for="iva" class="col-sm-12">I.V.A.</label>
                                                </div>  
                                                <div class="col-sm-2 form-floating form-label-inside input-div">
                                                    <input type="text" class="form-control" readonly id="totaltodo" name="totaltodo" placeholder="">
                                                    <label for="totaltodo" class="col-sm-12">TOTAL COTIZACIÓN</label>
                                                </div>  
                                                 
                                                                             
                                            </div>
                                            
                                            <div class="form-group row div-container">
                                                <div class="col-sm-4 form-floating form-row form-label-inside input-div" id="div_direccion" hidden>  
                                                    <input type="text" hidden class="form-control form-row col-10 campo_required" id="direccion_despacho" name="direccion_despacho" placeholder=" ">
                                                    <label for="direccion_despacho" hidden id="label_direccion" class="">Dirección Despacho</label>
                                                </div>
                                                <div class="col-sm-3 form-label-inside input-div">
                                                    <select class="form-control campo_required" id="ver_o_registrar" style="height: 58px;" name="ver_o_registrar">
                                                        <option value="">¿Ver o Registrar Cotización?</option>
                                                        <option value="Ver">Ver</option>
                                                        <option value="Registrar">Registrar</option>
                                                    </select> 
                                                </div>                                                                         
                                            </div>                                                   
                                            <hr>
                                          <!-- Botones para guardar y cerrar el formulario -->
                                          <div class="form-group d-flex justify-content-center align-items-center"><br>
                                            <button onclick="confirmarlo(event);" type="button" class="btn btn-block btn-primary" style="width: 60%;" >Registrar o Ver Cotización</button>
                                          </div>
                                        </form>


            </div>
          </div>

          </div>
          <!-- end page content-->
         </div>
         
         <?php include 'modal_cliente.php'; ?>
        <datalist name="codigos_productos" id="codigo_prod" class="col-12 bg-white" style="min-width: 500px;">
            <?php while ($row_prod = mysqli_fetch_assoc($query_producto)) { ?>
                <option value="<?php echo $row_prod['id_cod_producto']." | ".$row_prod['nombre_producto']." | ".$row_prod['precio_venta']." | ".$row_prod['n_serie']; ?>"></option>
            <?php } mysqli_free_result($query_producto); ?>
        </datalist>

        <datalist name="codigos_productos2" id="codigo_prod2" class="col-12 bg-white" style="width: 100%;">
        <?php while ($row_prod2 = mysqli_fetch_assoc($query_idcodprod)) { ?>
        <option value="<?php echo $row_prod2['id_producto']." | ".$row_prod2['id_cod_producto']." | ".$row_prod2['nombre_producto']." | ".$row_prod2['n_serie']." | ".$row_prod2['precio_venta']; ?>">
        </option>
        <?php } mysqli_free_result($query_idcodprod); ?>
        </datalist>

    <script type="text/javascript">        
        //CODIGO PARA MOSTRAR U OCULTAR ALERTA DE CODIGO REPETIDO.
        //TAMBIEN PARA CALCULAR LOS VALORES SI ES QUE EL CODIGO EXISTE, CALCULA, SI NO, LOS PONE EN MONTO 0.
        // Espera 2 segundos antes de ejecutar este código
            function alerta_noencontrado(){    
                var alerta = document.getElementsByClassName('alerta_noencontrado[]'); //ALERTA DANGER PROD NO ENCONTRADO
                var datalistoptions = document.getElementById("arreglo_piezas").options; //para comparacion con input prod
                var datalistprods = document.getElementById("codigo_prod").options; //datalist input seleccion producto
                var inputcampo = document.getElementsByClassName("repuesto_pieza[]"); //input codigo|nombre|precio
                var categoria = document.getElementsByClassName('categoria[]');
                var modelo = document.getElementsByClassName('modelo[]');  
                var total = document.getElementsByClassName('total[]'); 
                var valor = document.getElementsByClassName('valor[]'); 
                var cantidad = document.getElementsByClassName('cantidad[]');  
                var subtotal = document.getElementById("subtotal");
                var iva = document.getElementById("iva");
                var totaltodo = document.getElementById("totaltodo");            
                var n = 0;    
                var pruebss = "";       
                var arraycodsprods; 
                var arraytextprods;
                var categoriaprod;
                var modeloequipo;
                var temp_valor_prod = 0;
                // Verificar si el valor del input coincide con alguna opción del datalist
                for (var z = 0; z < inputcampo.length; z++) {
                    setTimeout(function(inputcampo, datalistoptions, categoria, modelo, alerta, z) {
                        n = 0;
                        for (var i = 0; i < datalistoptions.length; i++) {    
                            arraycodsprods = datalistoptions[i].value.split(' | ');
                            arraytextprods = datalistoptions[i].textContent.split(' | ');

                            if (inputcampo[z].value == arraycodsprods[0]) {
                                inputcampo[z].value = datalistoptions[i].value; 
                                categoriaprod = arraytextprods[0]; 
                                if (arraytextprods[1] != "") {
                                    modeloequipo = arraytextprods[1];
                                } else {
                                    modeloequipo = "";
                                }
                            }  

                            if (inputcampo[z].value == datalistoptions[i].value) {
                                n = n + 1;   // si es 1 es porque el input prod es igual a cod|nombre|precio, osea el value datalist
                                categoriaprod = arraytextprods[0]; 
                                if (arraytextprods[1] != "") {
                                    modeloequipo = arraytextprods[1]; 
                                } else {
                                    modeloequipo = "";
                                } 
                            }
                        }                    
                        
                        // IF PARA VERIFICAR INPUTS VACIOS Y SI SOLO 1 PRODUCTO COINCIDE ENTRE DATALIST E INPUTCAMPO ENTONCES..,
                        if (n == 1 && categoria[z].value == "" && modelo[z].value == "") {
                            alerta[z].hidden = true;
                            categoria[z].value = categoriaprod;
                            if (modeloequipo != "") {
                                modelo[z].value = modeloequipo;
                            } else {
                                modelo[z].value = "";
                            }                    
                            temp_valor_prod = valor[z].value; // monto del input valor del producto
                            total[z].value = cantidad[z].value * temp_valor_prod;
                            // temp_valor_prod = parseInt(temp_valor_prod.replace(/\./g, ''), 10);  
                            calculos_cotizacion();
                        } else if (n == 0) {
                            alerta[z].hidden = false;  
                            categoria[z].value = "";       
                            modelo[z].value = "";     
                            total[z].value = "0";
                            valor[z].value = "0";       
                        }           
                    }.bind(this, inputcampo, datalistoptions, categoria, modelo, alerta, z), 667); // Retardo de 667 milisegundos
                }
            }
        ////////////////////////////////////////////////////////////////////////////////////                
    </script>
    <script type="text/javascript">        
            function calculos_cotizacion(){    
                var alerta2 = document.getElementsByClassName('alerta_noencontrado[]');
                var inputcampo = document.getElementsByClassName("repuesto_pieza[]");
                var total = document.getElementsByClassName('total[]'); 
                var valor = document.getElementsByClassName('valor[]'); 
                var cantidad = document.getElementsByClassName('cantidad[]');   
                var categoria = document.getElementsByClassName('categoria[]');
                var modelo = document.getElementsByClassName('modelo[]'); 
                var descuento = document.getElementsByClassName('descuento[]');   
                var valor_descuento = 0;
                var subtotal = document.getElementById("subtotal");
                var iva = document.getElementById("iva");
                var totaltodo = document.getElementById("totaltodo"); 
                var total_descuentos = document.getElementById("total_descuentos"); 
                var monto_despachocalc = document.getElementById("monto_despacho").value.replace(/\./g, ''); 
                var valor_iva = 0;
                var subtotal_todo = 0;
                var temp_valor_prod = 0;
                var arraycodsprods;
                var temp_descuento = 0;
                var totales_descuentos = 0;
                var descuentoSinPuntos = "";
                var valorSinPuntos = "";
                // Verificar si el valor del input coincide con alguna opción del datalist
                for (var z = 0; z < inputcampo.length; z++) {
                    n = 0;         
                    if (cantidad[z].value == "") {
                        cantidad[z].value = 0;
                    } 
                    if (valor[z].value == "") {
                        valor[z].value = 0;
                    }   
                    if (categoria[z].value != "") {
                        valorSinPuntos = valor[z].value.replace(/\./g, '');
                        temp_valor_prod = valorSinPuntos; //monto del input valor del producto
                        total[z].value = parseInt(cantidad[z].value) * parseInt(temp_valor_prod);
                        total[z].value = total[z].value.replace(/[.]/g, '').replace(/\B(?=(\d{3})+(?!\d))/g, '.');
                        subtotal_todo = subtotal_todo + cantidad[z].value * temp_valor_prod;
                        //temp_valor_prod = parseInt(temp_valor_prod.replace(/\./g, ''), 10);  
                        //CALCULOS DESCUENTO PORCENTAJE Y VALOR PESOS
                        valor_descuento = 0;
                        arraycodsprods = inputcampo[z].value.split(' | ');
                        if (descuento[z].value == '') {
                            valor_descuento = 0;
                        } else {
                            descuentoSinPuntos = descuento[z].value.replace(/\./g, '');
                            valor_descuento = descuentoSinPuntos;
                        }  
                        if (parseInt(valor_descuento) < 101) {   
                            temp_descuento = parseInt(cantidad[z].value) * parseInt(temp_valor_prod);                 
                            valor_descuento = (temp_descuento / 100) * parseInt(valor_descuento);
                            totales_descuentos = totales_descuentos + parseInt(valor_descuento); //TOTAL DESCUENTOSS. 
                        }else if (parseInt(valor_descuento) > 100) {                            
                            totales_descuentos = totales_descuentos + parseInt(valor_descuento); //TOTAL DESCUENTOSS. 
                        }
                    }   
                    valorSinPuntos = valor[z].value.replace(/[^0-9]/g, '');
                    valorSinPuntos = new Intl.NumberFormat('es-CL').format(valorSinPuntos);
                    valor[z].value = valorSinPuntos;

                    cantidadSinPuntos = cantidad[z].value.replace(/[^0-9]/g, '');
                    cantidadSinPuntos = new Intl.NumberFormat('es-CL').format(cantidadSinPuntos);
                    cantidad[z].value = cantidadSinPuntos;

                    descuentoSinPuntos = descuento[z].value.replace(/[^0-9]/g, '');
                    descuentoSinPuntos = new Intl.NumberFormat('es-CL').format(descuentoSinPuntos);
                    descuento[z].value = descuentoSinPuntos;

                    totalSinPuntos = total[z].value.replace(/[^0-9]/g, '');
                    totalSinPuntos = totalSinPuntos - parseInt(valor_descuento);
                    totalSinPuntos = new Intl.NumberFormat('es-CL').format(totalSinPuntos);
                    total[z].value = totalSinPuntos;
                }
                total_descuentos.value = parseInt(totales_descuentos);
                total_descuentos.value=total_descuentos.value.replace(/[.]/g, '').replace(/\B(?=(\d{3})+(?!\d))/g, '.');

                subtotal_todo = parseInt(subtotal_todo) - parseInt(totales_descuentos) + parseInt(monto_despachocalc);
                subtotal.value = subtotal_todo;
                subtotal.value = subtotal.value.replace(/[.]/g, '').replace(/\B(?=(\d{3})+(?!\d))/g, '.');

                valor_iva = parseInt(subtotal_todo) * 0.19;
                iva.value = parseInt(valor_iva);
                iva.value=iva.value.replace(/[.]/g, '').replace(/\B(?=(\d{3})+(?!\d))/g, '.');
                var monto_despacho9 = document.getElementById("monto_despacho").value;
                var despacho_temp = "";
                var valor_despacho = monto_despacho9.replace(/[^0-9]/g, '');
                despacho_temp = valor_despacho;
                totaltodo.value = parseInt(valor_iva) + parseInt(subtotal_todo) + parseInt(despacho_temp);
                totaltodo.value=totaltodo.value.replace(/[.]/g, '').replace(/\B(?=(\d{3})+(?!\d))/g, '.');
            }             
    </script>
    
    <script type="text/javascript">
    $(function () { 
      var i = 0;      
      $('.add-btn').click(function (e) {
        e.preventDefault();
          i++;
          var n = i-1;
        $('.newData').append('<div id="newRow'+i+'" class="form-group row div-container">'    
                +'<div class="form-group col-sm-12" style="margin-bottom: -15px;">'
                  +'<div class="alert alert-danger alerta_noencontrado[] col-12" hidden="" role="alert">'
                    +'Producto no encontrado. Por favor asegurese de Seleccionar una opción del listado.'
                  +'</div>'
                +'</div>'
                +'<div class="form-group col-sm-5 form-floating form-label-inside input-div">'                       
                  +'<input type="text" placeholder="" id="repuesto_pieza'+n+'" list="codigo_prod" class="form-control repuesto_pieza[] campo_required"  name="repuesto_pieza[]" oninput="alerta_noencontrado(); completarAccesorios('+n+')" style="width: 100%;" >' 
                  +'<label for="repuesto_pieza'+n+'" class="col-sm-12">Equipo (Código | Nombre | Precio | Serie)</label>'                  
                +'</div>'  
                +'<div class="col-sm-2 form-floating form-label-inside input-div" readonly>'
                  +'<input type="text" placeholder="" readonly id="categoria'+n+'" class="form-control categoria[]"  name="categoria[]">'  
                  +'<label for="categoria'+n+'" class="col-sm-12">Categoría</label>' 
                +'</div>'   
                +'<div class="col-sm-2 form-floating form-label-inside input-div" >'
                  +'<input type="text" placeholder="" id="modelo'+n+'" value="" readonly class="form-control modelo[]" readonly name="modelo[]">'  
                  +'<label for="modelo'+n+'" class="col-sm-12">Modelo</label>' 
                +'</div>'   
                +'<div class="col-sm-2 form-floating form-label-inside input-div">'                           
                  +'<input type="text" placeholder="" id="valor'+n+'" oninput="calculos_cotizacion()" class=" form-control valor[] campo_required" name="valor[]">'  
                  +'<label for="valor'+n+'" class="col-sm-12">Valor</label>' 
                +'</div>' 
                +'<div class="col-sm-1 form-floating form-label-inside input-div">'
                  +'<input type="text" placeholder="" min="0" id="cantidad'+n+'" class=" form-control cantidad[] campo_required" oninput="calculos_cotizacion()" name="cantidad[]">'
                  +'<label for="cantidad'+n+'" class="col-sm-12">Cantidad</label>' 
                +'</div>'  
                
                + '   <div class="col-sm-4 form-floating form-label-inside input-div">'                
                + '       <div id="accessoryFieldsContainer' + n + '" class="accessory-fields-container col-12" style="border: 2px solid #808080; border-radius: 10px;"></div>'
                + '       <button type="button" class="btn add-accessory-btn btn-success col-12" style="height: 55px; color: white;" data-row-id="' + n + '">Agregar Accesorio y N° de Serie</button>'
                + '   </div>' 
                +'<div class="col-sm-2 form-floating form-label-inside input-div">'                                  
                  +'<input type="text" placeholder="" id="descuento'+n+'" oninput="calculos_cotizacion()" class="form-control descuento[]" name="descuento[]">'
                  +'<label for="descuento'+n+'" class="col-sm-12">Descuento</label>' 
                +'</div>' 
                +'<div class="col-sm-2 form-floating form-label-inside input-div">'                                  
                  +'<input type="text" placeholder="" readonly id="total'+n+'" class="form-control total[]" name="total[]">'
                  +'<label for="total'+n+'" class="col-sm-12">TOTAL PRODUCTO(S)</label>' 
                +'</div>'  
                +'<div class="col-sm-6 d-flex justify-content-left align-items-left form-floating form-label-inside input-div">'                 
                    +'<a href="#" class="remove-lnk btn add-btn btn-danger" style="background: #2a3042; height: 54px; width: 55px; color: white;" id="'+i+'"><strong>X</strong></a>'  
                +'</div>'
                +'<div class="col-sm-12 form-floating form-label-inside input-div">'                  
                  +'<hr>'   
                +'</div>'         
            +'</div>'
          );
      }); 
        $(document).on('click', '.add-accessory-btn', function (e) {
            e.preventDefault();
            var rowId = $(this).data('row-id');
            var accessoryIndex = $('#accessoryFieldsContainer' + rowId + ' .accessory-field').length;
            $('#accessoryFieldsContainer' + rowId).append(
                '<div class="form-group row accessory-field">'
                + '   <div class="col-sm-5 form-floating form-label-inside input-div">'
                + '       <input type="text" placeholder="" id="accesorio' + rowId + '_' + accessoryIndex + '" class="form-control" name="accesorio[' + rowId + '][]">'
                + '       <label for="accesorio' + rowId + '_' + accessoryIndex + '" class="col-sm-12">Accesorio</label>'
                + '   </div>'
                + '   <div class="col-sm-5 form-floating form-label-inside input-div">'
                + '       <input type="text" placeholder="" id="n_serie' + rowId + '_' + accessoryIndex + '" class="form-control" name="n_serie[' + rowId + '][]">'
                + '       <label for="n_serie' + rowId + '_' + accessoryIndex + '" class="col-sm-12">N° de Serie</label>'
                + '   </div>'
                + '   <div class="col-sm-2">'
                + '       <button type="button" class="btn btn-danger remove-accessory-btn" style="width: 50px; height: 55px;">X</button>'
                + '   </div>'
                + '</div>'
            );
        });

        $(document).on('click', '.remove-accessory-btn', function (e) {
            e.preventDefault();
            $(this).closest('.form-group.row').remove();
        });
        $(document).on('click', '.remove-lnk', function(e) {
         e.preventDefault();
          var id = $(this).attr("id");
           $('#newRow'+id+'').remove();
        });
        function completarAccesorios(rowId) {
            var datalistAccesorios = document.getElementById("accesorios_prod").options;//id_cod_producto|accesorio|serie| id_producto
            var list_prods = document.getElementById("codigo_prod").options;//id_cod_producto|nombre_producto|precio
            var list_prods2 = document.getElementById("codigo_prod2").options; //id_producto|id_cod_producto|nombre_producto
            var productoSeleccionado = document.getElementById('repuesto_pieza' + rowId).value.split(' | ')[0];//id_cod_producto
            var productonombreSelect = document.getElementById('repuesto_pieza' + rowId).value.split(' | ')[1]; //nombre prod 
            var id_producto_accs = "";
            for (var q = 0; q < list_prods2.length; q++){
                if (productonombreSelect == list_prods2[q].value.split(' | ')[2] && productoSeleccionado == list_prods2[q].value.split(' | ')[1]) {
                    id_producto_accs = list_prods2[q].value.split(' | ')[0];
                }
            }
            var containerAccesorios = document.getElementById('accessoryFieldsContainer' + rowId);
            // Limpiamos los campos actuales de accesorios
            containerAccesorios.innerHTML = '';
            // Buscamos y agregamos los accesorios correspondientes

            for (var i = 0; i < datalistAccesorios.length; i++) {
                var datosAccesorio = datalistAccesorios[i].value.split(' | ');//0 es id_cod_producto y 3 el id_producto
                if (datosAccesorio[0] === productoSeleccionado && id_producto_accs === datosAccesorio[3]) {
                    containerAccesorios.innerHTML += '<div class="form-group row accessory-field">'
                        + '   <div class="col-sm-5 form-floating form-label-inside input-div">'
                        + '       <input type="text" placeholder="" value="' + datosAccesorio[1] + '" readonly class="form-control" name="accesorio[' + rowId + '][]">'
                        + '       <label class="col-sm-12">Accesorio</label>'
                        + '   </div>'
                        + '   <div class="col-sm-5 form-floating form-label-inside input-div">'
                        + '       <input type="text" placeholder="" value="' + datosAccesorio[2] + '" readonly class="form-control" name="n_serie[' + rowId + '][]">'
                        + '       <label class="col-sm-12">N° de Serie</label>'
                        + '   </div>'
                        + '   <div class="col-sm-2">'
                        + '       <button type="button" class="btn btn-danger remove-accessory-btn" style="width: 50px; height: 55px;">X</button>'
                        + '   </div>'
                        + '</div>';
                }
            }
        }
        window.completarAccesorios = completarAccesorios;       
    });
  </script>

  <style>
  .btn-custom {
    background-color: #2a3042;
    color: white;
    height: 55px;
    margin-left: -15px;
  }
</style>

         <!--Start Back To Top Button-->
		     <a href="javaScript:;" class="back-to-top"><ion-icon name="arrow-up-outline"></ion-icon></a>
         <!--End Back To Top Button-->
  
        

         <!--start overlay-->
          <div class="overlay nav-toggle-icon"></div>
         <!--end overlay-->

     </div>
  <!--end wrapper-->
    <?php  
        //ALERTAS DE REGISTRO EXITOSO O ERROR EN BD.    
        $client="";
        $client=$_GET['client'];
        //$n_fact=$_GET['n_fact'];
        if ($client == "succ") {
            echo '<script>';
            echo 'Swal.fire({';
            echo '  title: "Registro exitoso",';
            echo '  text: "La Cotización fue registrado correctamente.",';
            echo '  icon: "success",';
            echo '  confirmButtonText: "Aceptar",';
            echo '  confirmButtonColor: "#2a3042",';
            echo '});';
            echo 'history.replaceState({}, document.title, window.location.pathname);';
            echo '</script>';
        }elseif ($client == 'err') {
            echo '<script>';
            echo 'Swal.fire({';
            echo '  title: "Error",';
            echo '  text: "Hubo un error en la base de datos",';
            echo '  icon: "error",';
            echo '  confirmButtonText: "Aceptar",';
            echo '  confirmButtonColor: "#2a3042"';
            echo '});';
            echo 'history.replaceState({}, document.title, window.location.pathname);';
            echo '</script>';  
        } elseif ($client == 'campos_vacios') {
            echo '<script>';
            echo 'Swal.fire({';
            echo '  title: "Información",';
            echo '  text: "Debe completar los campos requeridos por favor",';
            echo '  icon: "warning",';
            echo '  confirmButtonText: "Aceptar",';
            echo '  confirmButtonColor: "#2a3042"';
            echo '});';
            echo 'history.replaceState({}, document.title, window.location.pathname);';
            echo '</script>';  
        }
    ?>

    <!-- JS Files-->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="assets/js/jquery.min.js"></script>
    <script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
    <script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
    <script src="assets/js/bootstrap.bundle.min.js"></script>
    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
    <!--plugins-->
    <script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
    <script src="assets/plugins/input-tags/js/tagsinput.js"></script>

    <!-- Main JS-->
    <script src="assets/js/main.js"></script>


  </body>
</html>