<?php
include('datos_sistema.php');

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $idUsuario = $_GET['id_usuario'];
    // Utiliza una consulta preparada para evitar la inyección SQL
    $sql = "SELECT * FROM cliente WHERE id_cliente=?";
    $stmt = mysqli_prepare($con, $sql);
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, 'i', $idUsuario);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        if ($result) {
            $data = mysqli_fetch_assoc($result);
            echo json_encode($data);
        } else {
            echo json_encode(['error' => 'Error al obtener detalles del Cliente']);
        }

        mysqli_stmt_close($stmt);
    } else {
        echo json_encode(['error' => 'Error al preparar la consulta']);
    }
} else {
    echo json_encode(['error' => 'Método no permitido']);
}
?>