<?php
    include("datos_sistema.php");
    //TOTAL USUARIOS
    /*error_reporting(E_ALL);
ini_set('display_errors', 1);*/
    $sqluser = "SELECT * FROM usuario WHERE estado='Activo'";
    $queryuser = mysqli_query($con, $sqluser);
    $countuser = mysqli_num_rows($queryuser);

    //TOTAL CLIENTES
    $sqlcliente = "SELECT * FROM cliente WHERE estado='Activo'";
    $querycliente = mysqli_query($con, $sqlcliente);
    $countcliente = mysqli_num_rows($querycliente);

    //TODAS DE GANANCIAS VENTAS DE COTIZACIONES.
    $sqlcotizacion = "SELECT SUM(REPLACE(total_cotizacion, '.', '')) AS total_suma FROM cotizacion WHERE estado='Activo'";
    $querycotizacion = mysqli_query($con, $sqlcotizacion);
    $row = mysqli_fetch_assoc($querycotizacion);
    $total_cotizaciones = $row['total_suma'];
    $total_cotizaciones = number_format($total_cotizaciones, 0, '', '.');

    //TOTAL CANTIDAD PRODUCTOS
    $sqlproductos = "SELECT * FROM productos WHERE estado_producto='Activo'";
    $queryproductos = mysqli_query($con, $sqlproductos);
    $countproductos = mysqli_num_rows($queryproductos);

    //TODAS DE GANANCIAS VENTAS DE PRODUCTOS POR CAJA VENTAS.
    $presente_año = date('Y'); // Año actual
    //$last_year = date('Y') - 1; // Año pasado
    // Consulta SQL para obtener la suma total por el último año
    $sqlcaja_ventas = "SELECT SUM(CAST(REPLACE(total_a_pagar, '.', '') AS UNSIGNED)) AS total_caja
                       FROM caja_ventas
                       WHERE estado = 'Activo'
                       AND YEAR(fecha) = $presente_año";
    // Ejecutar la consulta
    $querycaja_ventas = mysqli_query($con, $sqlcaja_ventas);
    // Verificar si la consulta se ejecutó correctamente
    if (!$querycaja_ventas) {
        die("Error en la consulta: " . mysqli_error($con));
    }
    // Obtener el resultado
    $row_caja = mysqli_fetch_assoc($querycaja_ventas);

    $total_caja_ventas2 = $row_caja['total_caja'] ?? 0;
    $total_caja_ventas = number_format($total_caja_ventas2, 0, '', '.');



    /*$total_caja_ventas2 = $row_caja['total_caja'];
    $total_caja_ventas = number_format($total_caja_ventas2, 0, '', '.');*/

    /*$sqlcaja_ventas = "SELECT SUM(REPLACE(total_a_pagar, '.', '')) AS total_caja FROM caja_ventas WHERE estado='Activo'";
    $querycaja_ventas = mysqli_query($con, $sqlcaja_ventas);
    $row_caja = mysqli_fetch_assoc($querycaja_ventas);
    $total_caja_ventas = $row_caja['total_caja'];*/

    //CALCULO DE ARRIENDO, INGRESOS MENSUALES, TOTAL.
    $presente_añoarriendo = date('Y'); // Año actual
    // Consulta SQL para obtener la suma total de "arriendo" por el último año
    $sql_arriendo = "SELECT SUM(CAST(REPLACE(total_a_pagar, '.', '') AS UNSIGNED)) AS total_arriendo
                     FROM arriendo
                     WHERE estado = 'Activo'
                     AND YEAR(fecha_retiro) = $presente_añoarriendo";
    $query_arriendo = mysqli_query($con, $sql_arriendo);
    if (!$query_arriendo) {
        die("Error en la consulta: " . mysqli_error($con));
    }
    $row_arriendo = mysqli_fetch_assoc($query_arriendo);
    /*$total_arriendo2 = $row_arriendo['total_arriendo'];
    $total_arriendo = number_format($total_arriendo2, 0, '', '.');*/
    $total_arriendo2 = $row_arriendo['total_arriendo'] ?? 0;
$total_arriendo = number_format($total_arriendo2, 0, '', '.');

    $total_caja_ventas2_sin_puntos = str_replace('.', '', $total_caja_ventas2);
    $total_arriendo2_sin_puntos = str_replace('.', '', $total_arriendo2);
    $total_caja_arriendo_sin_puntos = $total_caja_ventas2_sin_puntos + $total_arriendo2_sin_puntos;

    // Formatear el resultado con puntos de mil para la visualización correcta
    $total_caja_arriendo = number_format($total_caja_arriendo_sin_puntos, 0, '', '.');

    //TOTAL DE PRODUCTOS ARRENDADOS.
    $sql = "
        SELECT SUM(ap.cantidad) AS total_prods_arrendados
        FROM arriendo_productos ap
        JOIN arriendo a ON ap.id_arriendo = a.id_arriendo
        WHERE a.estado = 'Activo'
    ";
    $query = mysqli_query($con, $sql);
    // Obtener el resultado
    $row = mysqli_fetch_assoc($query);
    $total_prods_arrendados = $row['total_prods_arrendados'];

    //TOTAL DE PRODUCTOS PRESTADOS.
    $sql_prestamos = "
        SELECT SUM(ap.cantidad) AS total_prods_prestados
        FROM prestamo_productos ap
        JOIN prestamo a ON ap.id_prestamo = a.id_prestamo
        WHERE a.estado = 'Activo'
    ";
    $query_prestamos = mysqli_query($con, $sql_prestamos);
    // Obtener el resultado
    $row_prestamos = mysqli_fetch_assoc($query_prestamos);
    $total_prods_prestados = $row_prestamos['total_prods_prestados'];

    //TOTAL DE PRODUCTOS CONSIGNADOS.
    $sql_consignados = "
        SELECT SUM(ap.cantidad) AS total_prods_consignados
        FROM consignacion_productos ap
        JOIN consignacion a ON ap.id_consignacion = a.id_consignacion
        WHERE a.estado = 'Activo'
    ";
    $query_consignados = mysqli_query($con, $sql_consignados);
    // Obtener el resultado
    $row_consignados = mysqli_fetch_assoc($query_consignados);
    $total_prods_consignados = $row_consignados['total_prods_consignados'];


    //RESCATA LOS MONTOS TOTALES DE CAJA VENTAS, Y ALMACENA POR MES EN UN ARRAY, Y SE MUESTRA EN EL GRÁFICO INFORME GANANCIAS POR CAJA VENTAS 2024.
    // Obtener el año actual
    $current_year = date('Y');
    // Consulta SQL para obtener la suma total por mes del último año
    $sql_ventas_meses = "SELECT
                DATE_FORMAT(fecha, '%Y-%m') AS mes,
                SUM(CAST(REPLACE(total_a_pagar, '.', '') AS UNSIGNED)) AS total_mes
            FROM
                caja_ventas
            WHERE
                YEAR(fecha) = $current_year
                AND estado = 'Activo'
            GROUP BY
                DATE_FORMAT(fecha, '%Y-%m')
            ORDER BY
                DATE_FORMAT(fecha, '%Y-%m')";
    $result_ventas_meses = $con->query($sql_ventas_meses);
    // Verificar si hubo un error en la consulta
    if (!$result_ventas_meses) {
        die("Error en la consulta: " . $con->error);
    }
    // Inicializar un array para almacenar los totales por mes
    $totales_por_mes = array();
    // Procesar el resultado de la consulta
    if ($result_ventas_meses->num_rows > 0) {
        while($row_meses = $result_ventas_meses->fetch_assoc()) {
            // El total ya está limpiado en la consulta SQL, así que no es necesario hacer más transformaciones en PHP
            $total_mes = $row_meses['total_mes'];
            // Almacenar el total en el array con el mes como clave
            $totales_por_mes[$row_meses['mes']] = $total_mes;
        }
    } else {
        echo "0 results";
    }


    //TOP MEJORES CLIENTES
    $sql_mejores_clientes = "SELECT id_cliente, SUM(total_pagar_sin_puntos) AS total_pagado FROM (
        SELECT 
            id_cliente,
            SUM(CAST(REPLACE(total_a_pagar, '.', '') AS UNSIGNED)) AS total_pagar_sin_puntos
        FROM 
            caja_ventas
        WHERE 
            estado = 'Activo'
        GROUP BY 
            id_cliente
        UNION ALL

        SELECT 
            id_cliente,
            SUM(CAST(REPLACE(total_a_pagar, '.', '') AS UNSIGNED)) AS total_pagar_sin_puntos
        FROM 
            arriendo
        WHERE 
            estado = 'Activo'
        GROUP BY 
            id_cliente
    ) AS clientes_totales
    GROUP BY id_cliente
    ORDER BY total_pagado DESC
    LIMIT 6
    ";
    // Ejecutar la consulta
    $result_mejores_clientes = mysqli_query($con, $sql_mejores_clientes);
    // Verificar si la consulta se ejecutó correctamente
    if (!$result_mejores_clientes) {
        die("Error en la consulta: " . mysqli_error($con));
    }
    
    //CLIENTES USUARIOS QUE REALIZARON ARRIENDO, PRESTAMOS CONSIGNACION.
    $sql_arriendo_count = "SELECT COUNT(*) AS total_arriendo FROM arriendo WHERE estado = 'Activo'";
    $sql_consignacion_count = "SELECT COUNT(*) AS total_consignacion FROM consignacion WHERE estado = 'Activo'";
    $sql_prestamo_count = "SELECT COUNT(*) AS total_prestamo FROM prestamo WHERE estado = 'Activo'";
    // Ejecutar la consulta para "arriendo"
    $result_arriendo_count = mysqli_query($con, $sql_arriendo_count);
    $row_arriendo_count = mysqli_fetch_assoc($result_arriendo_count);
    $total_arriendo = $row_arriendo_count['total_arriendo'];
    // Ejecutar la consulta para "consignacion"
    $result_consignacion_count = mysqli_query($con, $sql_consignacion_count);
    $row_consignacion_count = mysqli_fetch_assoc($result_consignacion_count);
    $total_consignacion = $row_consignacion_count['total_consignacion'];
    // Ejecutar la consulta para "prestamo"
    $result_prestamo_count = mysqli_query($con, $sql_prestamo_count);
    $row_prestamo_count = mysqli_fetch_assoc($result_prestamo_count);
    $total_prestamo = $row_prestamo_count['total_prestamo'];
?>

<!doctype html>
<html lang="en">

<head>
  <!-- Required meta tags -->
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- loader-->
  <link href="assets/css/pace.min.css" rel="stylesheet" />
  <script src="assets/js/pace.min.js"></script>

  <!--plugins-->
  <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
  <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
  <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />

  <!-- CSS Files -->
  <link href="assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
  <link href="assets/css/style.css" rel="stylesheet">
  <link href="assets/css/icons.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">

  <!--Theme Styles-->
  <link href="assets/css/dark-theme.css" rel="stylesheet" />
  <link href="assets/css/semi-dark.css" rel="stylesheet" />
  <link href="assets/css/header-colors.css" rel="stylesheet" />
  <!-- CSS de SweetAlert2 PARA LA ALERTA ANIMADA CADA VEZ QUE SE REALIZA EDITAR, ELIMINAR ETC. -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.18/dist/sweetalert2.min.css">
    <!-- JS de SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.18/dist/sweetalert2.all.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

  <title>GESTION NEOTOP</title>
  <link rel="icon" type="image/png" href="icono.png">
</head>

<body>


  <!--start wrapper-->
  <div class="wrapper">

    <?php include("menu_vector.php");  ?>


    <!-- start page content wrapper-->
    <div class="page-content-wrapper">
      <!-- start page content-->
      <div class="page-content">

        <!--start breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
          <div class="breadcrumb-title pe-3">Dashboard</div>
          <div class="ps-3">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb mb-0 p-0 align-items-center">
                <li class="breadcrumb-item"><a href="javascript:;">
                    <ion-icon name="home-outline"></ion-icon>
                  </a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Dashboard</li>
              </ol>
            </nav>
          </div>
         
        </div>
        <!--end breadcrumb-->


        <div class="row row-cols-1 row-cols-lg-2 row-cols-xxl-4">
          <div class="col">
            <div class="card radius-10">
              <div class="card-body">
                <div class="d-flex align-items-start gap-2">
                  <div>
                    <p class="mb-0 fs-6">Total Usuarios</p>
                  </div>
                  <div class="ms-auto widget-icon-small text-white bg-gradient-purple">
                    <ion-icon name="wallet-outline"></ion-icon>
                  </div>
                </div>
                <div class="d-flex align-items-center mt-3">
                  <div>
                    <h4 class="mb-0"><?php echo $countuser  ?></h4>
                  </div>
                  <div class="ms-auto"></div>
                </div>
              </div>
            </div>
          </div>
          <div class="col">
            <div class="card radius-10">
              <div class="card-body">
                <div class="d-flex align-items-start gap-2">
                  <div>
                    <p class="mb-0 fs-6">Total Clientes</p>
                  </div>
                  <div class="ms-auto widget-icon-small text-white bg-gradient-info">
                    <ion-icon name="people-outline"></ion-icon>
                  </div>
                </div>
                <div class="d-flex align-items-center mt-3">
                  <div>
                    <h4 class="mb-0"><?php echo $countcliente  ?></h4>
                  </div>
                  <div class="ms-auto"></div>
                </div>
              </div>
            </div>
          </div>
          <div class="col">
            <div class="card radius-10">
              <div class="card-body">
                <div class="d-flex align-items-start gap-2">
                  <div>
                    <p class="mb-0 fs-6">Cantidad Productos Nuevos</p>
                  </div>
                  <div class="ms-auto widget-icon-small text-white bg-gradient-success">
                    <ion-icon name="bar-chart-outline"></ion-icon>
                  </div>
                </div>
                <div class="d-flex align-items-center mt-3">
                  <div>
                    <h4 class="mb-0"><?php echo $countproductos  ?></h4>
                  </div>
                  <div class="ms-auto"></div>
                </div>
              </div>
            </div>
          </div>
          <div class="col">
            <div class="card radius-10">
              <div class="card-body">
                <div class="d-flex align-items-start gap-2">
                  <div>
                    <p class="mb-0 fs-6">Total Cotizaciones</p>
                  </div>
                  <div class="ms-auto widget-icon-small text-white bg-gradient-danger">
                    <ion-icon name="bag-handle-outline"></ion-icon>
                  </div>
                </div>
                <div class="d-flex align-items-center mt-3">
                  <div>
                    <h4 class="mb-0"><?php echo "$ ".$total_cotizaciones  ?></h4>
                  </div>
                  <div class="ms-auto"></div>
                </div>
              </div>
            </div>
          </div>
          
          <div class="col">
            <div class="card radius-10">
              <div class="card-body">
                <div class="d-flex align-items-start gap-2">
                  <div>
                    <p class="mb-0 fs-6">Total Ventas Caja</p>
                  </div>
                  <div class="ms-auto widget-icon-small text-white bg-gradient-success">
                    <ion-icon name="bar-chart-outline"></ion-icon>
                  </div>
                </div>
                <div class="d-flex align-items-center mt-3">
                  <div>
                    <h4 class="mb-0"><?php echo "$ ".$total_caja_ventas  ?></h4>
                  </div>
                  <div class="ms-auto"></div>
                </div>
              </div>
            </div>
          </div>
          <div class="col">
            <div class="card radius-10">
              <div class="card-body">
                <div class="d-flex align-items-start gap-2">
                  <div>
                    <p class="mb-0 fs-6">Total Productos Arrendados</p>
                  </div>
                  <div class="ms-auto widget-icon-small text-white bg-gradient-success">
                    <ion-icon name="bar-chart-outline"></ion-icon>
                  </div>
                </div>
                <div class="d-flex align-items-center mt-3">
                  <div>
                    <h4 class="mb-0"><?php echo $total_prods_arrendados  ?></h4>
                  </div>
                  <div class="ms-auto"></div>
                </div>
              </div>
            </div>
          </div>
          <div class="col">
            <div class="card radius-10">
              <div class="card-body">
                <div class="d-flex align-items-start gap-2">
                  <div>
                    <p class="mb-0 fs-6">Total Productos Prestados</p>
                  </div>
                  <div class="ms-auto widget-icon-small text-white bg-gradient-success">
                    <ion-icon name="bar-chart-outline"></ion-icon>
                  </div>
                </div>
                <div class="d-flex align-items-center mt-3">
                  <div>
                    <h4 class="mb-0"><?php echo $total_prods_prestados  ?></h4>
                  </div>
                  <div class="ms-auto"></div>
                </div>
              </div>
            </div>
          </div>
          <div class="col">
            <div class="card radius-10">
              <div class="card-body">
                <div class="d-flex align-items-start gap-2">
                  <div>
                    <p class="mb-0 fs-6">Total Productos Consignados</p>
                  </div>
                  <div class="ms-auto widget-icon-small text-white bg-gradient-success">
                    <ion-icon name="bar-chart-outline"></ion-icon>
                  </div>
                </div>
                <div class="d-flex align-items-center mt-3">
                  <div>
                    <h4 class="mb-0"><?php echo $total_prods_consignados  ?></h4>
                  </div>
                  <div class="ms-auto"></div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!--end row-->


        <div class="row row-cols-1 row-cols-lg-3">
          <!--<div class="col">
            <div class="card radius-10 w-100">
              <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                  <h6 class="mb-0">Sales by Countries</h6>
                  <div class="dropdown options ms-auto">
                    <div class="dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown">
                      <ion-icon name="ellipsis-horizontal-outline" class="md hydrated"></ion-icon>
                    </div>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="#">Action</a></li>
                      <li><a class="dropdown-item" href="#">Another action</a></li>
                      <li><a class="dropdown-item" href="#">Something else here</a></li>
                    </ul>
                  </div>
                </div>
                <div class="countries-list">
                  <div class="d-flex align-items-center gap-3 mb-3">
                    <div class="country-icon">
                      <img src="assets/images/icons/usa.png" alt="" width="35">
                    </div>
                    <div class="country-name flex-grow-1">
                      <h5 class="mb-0">$84.5K</h5>
                      <p class="mb-0 text-secondary">United states</p>
                    </div>
                    <div class="">
                      <p class="mb-0 text-success d-flex gap-1 align-items-center fw-500"><i class='bx bx-up-arrow-alt'></i><span>25%</span></p>
                    </div>
                  </div>
                  <div class="d-flex align-items-center gap-3 mb-3">
                    <div class="country-icon">
                      <img src="assets/images/icons/india.png" alt="" width="35">
                    </div>
                    <div class="country-name flex-grow-1">
                      <h5 class="mb-0">$750</h5>
                      <p class="mb-0 text-secondary">India</p>
                    </div>
                    <div class="">
                      <p class="mb-0 text-success d-flex gap-1 align-items-center fw-500"><i class='bx bx-up-arrow-alt'></i><span>18%</span></p>
                    </div>
                  </div>
                  <div class="d-flex align-items-center gap-3 mb-3">
                    <div class="country-icon">
                      <img src="assets/images/icons/china.png" alt="" width="35">
                    </div>
                    <div class="country-name flex-grow-1">
                      <h5 class="mb-0">$38.5</h5>
                      <p class="mb-0 text-secondary">China</p>
                    </div>
                    <div class="">
                      <p class="mb-0 text-danger d-flex gap-1 align-items-center fw-500"><i class='bx bx-down-arrow-alt'></i><span>14%</span></p>
                    </div>
                  </div>
                  <div class="d-flex align-items-center gap-3 mb-3">
                    <div class="country-icon">
                      <img src="assets/images/icons/russia.png" alt="" width="35">
                    </div>
                    <div class="country-name flex-grow-1">
                      <h5 class="mb-0">$88.0K</h5>
                      <p class="mb-0 text-secondary">France</p>
                    </div>
                    <div class="">
                      <p class="mb-0 text-success d-flex gap-1 align-items-center fw-500"><i class='bx bx-up-arrow-alt'></i><span>28%</span></p>
                    </div>
                  </div>
                  <div class="d-flex align-items-center gap-3 mb-3">
                    <div class="country-icon">
                      <img src="assets/images/icons/australia.png" alt="" width="35">
                    </div>
                    <div class="country-name flex-grow-1">
                      <h5 class="mb-0">$78.3K</h5>
                      <p class="mb-0 text-secondary">Australia</p>
                    </div>
                    <div class="">
                      <p class="mb-0 text-danger d-flex gap-1 align-items-center fw-500"><i class='bx bx-down-arrow-alt'></i><span>16%</span></p>
                    </div>
                  </div>
                  <div class="d-flex align-items-center gap-3 mb-3">
                    <div class="country-icon">
                      <img src="assets/images/icons/brazil.png" alt="" width="35">
                    </div>
                    <div class="country-name flex-grow-1">
                      <h5 class="mb-0">$10.5K</h5>
                      <p class="mb-0 text-secondary">Brazil</p>
                    </div>
                    <div class="">
                      <p class="mb-0 text-success d-flex gap-1 align-items-center fw-500"><i class='bx bx-up-arrow-alt'></i><span>25%</span></p>
                    </div>
                  </div>
                  <div class="d-flex align-items-center gap-3 mb-0">
                    <div class="country-icon">
                      <img src="assets/images/icons/UAE.png" alt="" width="35">
                    </div>
                    <div class="country-name flex-grow-1">
                      <h5 class="mb-0">$30.5K</h5>
                      <p class="mb-0 text-secondary">UAE</p>
                    </div>
                    <div class="">
                      <p class="mb-0 text-success d-flex gap-1 align-items-center fw-500"><i class='bx bx-up-arrow-alt'></i><span>25%</span></p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col">
            <div class="card radius-10">
              <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                  <h6 class="mb-0">Total Earning</h6>
                  <div class="dropdown options ms-auto">
                    <div class="dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown">
                      <ion-icon name="ellipsis-horizontal-outline" class="md hydrated"></ion-icon>
                    </div>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="#">Action</a></li>
                      <li><a class="dropdown-item" href="#">Another action</a></li>
                      <li><a class="dropdown-item" href="#">Something else here</a></li>
                    </ul>
                  </div>
                </div>
                <div class="d-flex align-items-center gap-2 mb-3">
                  <h2 class="mb-0">68%</h2>
                  <div class="">
                    <p class="mb-0 text-success d-flex gap-1 align-items-center fw-500 fs-6"><i class='bx bx-up-arrow-alt'></i><span>25%</span></p>
                  </div>
                </div>
                <div id="chart1"></div>
                <div class="mt-4">
                  <div class="d-flex align-items-center gap-3 mb-3">
                    <div class="widget-icon-small rounded bg-light-success text-success">
                      <ion-icon name="wallet-outline"></ion-icon>
                    </div>
                    <div class="flex-grow-1">
                      <h6 class="mb-0">$545.69</h6>
                      <p class="mb-0 text-secondary">Last Month Sales</p>
                    </div>
                    <div class="">
                      <p class="mb-0 text-success d-flex gap-1 align-items-center fw-500 fs-6"><i class='bx bx-up-arrow-alt'></i><span>35%</span></p>
                    </div>
                  </div>
                  <div class="d-flex align-items-center gap-3 mb-3">
                    <div class="widget-icon-small rounded bg-light-tiffany text-tiffany">
                      <ion-icon name="flag-outline"></ion-icon>
                    </div>
                    <div class="flex-grow-1">
                      <h6 class="mb-0">$956.34</h6>
                      <p class="mb-0 text-secondary">Last Month Sales</p>
                    </div>
                    <div class="">
                      <p class="mb-0 text-danger d-flex gap-1 align-items-center fw-500 fs-6"><i class='bx bx-up-arrow-alt'></i><span>45%</span></p>
                    </div>
                  </div>
                  <div class="d-flex align-items-center gap-3">
                    <div class="widget-icon-small rounded bg-light-danger text-danger">
                      <ion-icon name="school-outline"></ion-icon>
                    </div>
                    <div class="flex-grow-1">
                      <h6 class="mb-0">$6956.48</h6>
                      <p class="mb-0 text-secondary">Last Year Sales</p>
                    </div>
                    <div class="">
                      <p class="mb-0 text-success d-flex gap-1 align-items-center fw-500 fs-6"><i class='bx bx-up-arrow-alt'></i><span>66%</span></p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col">
            <div class="card radius-10 overflow-hidden w-100">
              <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                  <h6 class="mb-0">Total Traffic</h6>
                  <div class="dropdown options ms-auto">
                    <div class="dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown">
                      <ion-icon name="ellipsis-horizontal-outline"></ion-icon>
                    </div>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="javascript:;">Action</a></li>
                      <li><a class="dropdown-item" href="javascript:;">Another action</a></li>
                      <li><a class="dropdown-item" href="javascript:;">Something else here</a></li>
                    </ul>
                  </div>
                </div>
                <div class="d-flex align-items-center font-13 gap-2">
                  <span class="border px-1 rounded cursor-pointer"><i class="bx bxs-circle me-1 text-tiffany"></i>Cliks</span>
                  <span class="border px-1 rounded cursor-pointer"><i class="bx bxs-circle me-1 text-success"></i>Views</span>
                </div>
                <div id="chart2"></div>
              </div>
            </div>
          </div>-->
        </div><!--end row-->


        <div class="row">
          <div class="col-12 col-xl-12 d-flex">
            <div class="card radius-10 w-100">
              <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                  <h6 class="mb-0">Informe de Ganancias Caja Ventas año <?php echo $current_year; ?></h6>
                  <!--<div class="dropdown options ms-auto">
                    <div class="dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown">
                      <ion-icon name="ellipsis-horizontal-outline"></ion-icon>
                    </div>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="javascript:;">Action</a></li>
                      <li><a class="dropdown-item" href="javascript:;">Another action</a></li>
                      <li><a class="dropdown-item" href="javascript:;">Something else here</a></li>
                    </ul>
                  </div>-->
                </div>
               <div class="row g-4 align-items-center mb-4">
                  <div class="col-12 col-xl-4">
                     <div class="d-flex align-items-center gap-2 mb-3">
                         <h1 class="mb-0">$0</h1>
                         <p class="mb-0 text-success bg-light-success px-2 rounded py-1">+10.6%</p>
                     </div>
                     <p class="mb-0">*Pendiente*, Este monto puede ser la diferencia con el mes anterior o con el año anterior, para tener una comparación según sea necesario o de ambas si se desea.</p>
                  </div>
                  <div class="col-12 col-xl-8">
                              <div id="chart20"></div> <!-- Primer gráfico -->
                          </div>
               </div><!--end row-->
               <div class="d-flex flex-column flex-lg-row align-items-lg-center align-self-end justify-content-lg-between border p-3 gap-3 mb-0 rounded-3">
                <div class="d-flex align-items-center gap-3">
                  <div class="widget-icon rounded-circle bg-light-success text-success">
                    <ion-icon name="card-outline"></ion-icon>
                  </div>
                  <div class="">
                    <h4 class="mb-0"><?PHP echo "$ ".$total_caja_arriendo ?></h4>
                    <p class="mb-0 text-secondary">Ingresos Totales</p>
                  </div>
                </div>
                <div class="vr d-none d-lg-block"></div>
                <div class="d-flex align-items-center gap-3">
                  <div class="widget-icon rounded-circle bg-light-info text-info">
                    <ion-icon name="diamond-outline"></ion-icon>
                  </div>
                  <div class="">
                    <h4 class="mb-0"><?PHP echo "$ ".$total_caja_ventas ?></h4>
                    <p class="mb-0 text-secondary">Ingresos Productos Nuevos</p>
                  </div>
                </div>
                <div class="vr d-none d-lg-block"></div>
                <div class="d-flex align-items-center gap-3">
                  <div class="widget-icon rounded-circle bg-light-purple text-purple">
                    <ion-icon name="people-circle-outline"></ion-icon>
                  </div>
                  <div class="">
                    <h4 class="mb-0"><?PHP echo "$ ".$total_arriendo ?></h4>
                    <p class="mb-0 text-secondary">Ingresos por Arriendos (Mensual)</p>
                  </div>
                </div>
              </div>
              </div>
            </div>
          </div>
          <!--<div class="col-12 col-xl-8 d-flex">
              <div class="card radius-10 w-100">
                  <div class="card-body">
                      <div class="d-flex align-items-center mb-3">
                          <h6 class="mb-0">Informe de Ganancias</h6>
                          <div class="dropdown options ms-auto">
                              <div class="dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown">
                                  <ion-icon name="ellipsis-horizontal-outline"></ion-icon>
                              </div>
                              <ul class="dropdown-menu">
                                  <li><a class="dropdown-item" href="javascript:;">Action</a></li>
                                  <li><a class="dropdown-item" href="javascript:;">Another action</a></li>
                                  <li><a class="dropdown-item" href="javascript:;">Something else here</a></li>
                              </ul>
                          </div>
                      </div>

                      <div class="row g-4 align-items-center mb-4">
                          <div class="col-12 col-xl-4">
                              <div class="d-flex align-items-center gap-2 mb-3">
                                  <h1 class="mb-0">$856</h1>
                                  <p class="mb-0 text-success bg-light-success px-2 rounded py-1">+10.6%</p>
                              </div>
                              <p class="mb-0">In publishing and graphic design, Lorem ipsum is a placeholder text commonly used to demonstrate.</p>
                          </div>
                          <div class="col-12 col-xl-8">
                              <div id="chart20"></div> 
                          </div>
                      </div>
                      
                      <div class="d-flex flex-column flex-lg-row align-items-lg-center align-self-end justify-content-lg-between border p-3 gap-3 mb-0 rounded-3">
                          <div class="d-flex align-items-center gap-3">
                              <div class="widget-icon rounded-circle bg-light-success text-success">
                                  <ion-icon name="card-outline"></ion-icon>
                              </div>
                              <div class="">
                                  <h4 class="mb-0">$95,286.50</h4>
                                  <p class="mb-0 text-secondary">Ingresos Totales</p>
                              </div>
                          </div>
                      </div>
                     
                      
                  </div>
              </div>
          </div>-->
          <!--<div class="col-12 col-xl-4 d-flex">
            <div class="card radius-10 overflow-hidden w-100">
              <div class="card-body">
                <div class="d-flex flex-column gap-3">
                  <div class="card border shadow-none radius-10 flex-grow-1 mb-0">
                    <div class="card-body">
                      <div class="d-flex align-items-start gap-2">
                        <div>
                          <h5 class="mb-0 ">Total Accounts</h5>
                        </div>
                        <div class="ms-auto widget-icon-2 text-white bg-info rounded-circle">
                          <ion-icon name="people-outline"></ion-icon>
                        </div>
                      </div>
                      <div class="">
                        <h3 class="mb-2">68,542</h3>
                        <div class="d-flex align-items-center gap-2">
                           <div class="widget-icon-small bg-light-danger text-danger">
                            <ion-icon name="arrow-down-outline"></ion-icon>
                           </div>
                           <p class="mb-0">+9% last year</p>
                        </div>
                      </div>
                      <div id="chart20"></div>
                    </div>
                  </div>
                  <div class="card border shadow-none radius-10 mb-0">
                    <div class="card-body">
                      <div class="d-flex align-items-start gap-2">
                        <div><p class="mb-0">Disk Space</p></div>
                        <div class="dropdown options ms-auto">
                          <div class="dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown">
                            <ion-icon name="ellipsis-horizontal-outline"></ion-icon>
                          </div>
                          <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="javascript:;">Action</a></li>
                            <li><a class="dropdown-item" href="javascript:;">Another action</a></li>
                            <li><a class="dropdown-item" href="javascript:;">Something else here</a></li>
                          </ul>
                        </div>
                      </div>
                      <div class="d-flex align-items-center mt-3">
                       <div>
                         <h4 class="mb-3">48GB</h4>
                         <div class="d-flex align-items-center gap-2">
                          <div class="widget-icon-small bg-light-danger text-danger">
                           <ion-icon name="arrow-down-outline"></ion-icon>
                          </div>
                          <p class="mb-0">+7% last month</p>
                       </div>
                       </div>
                       <div class="ms-auto">
                         <div class="w_chart" id="chart5" data-percent="60">
                           <span class="w_percent"></span>
                         </div>
                       </div>
                      </div>
                    </div>
                   </div>
                </div>
              </div>
            </div>
          </div>-->
        </div>
        <!--end row-->
        
        <div class="row">
          <div class="col-12 col-lg-12 col-xl-6 d-flex">
            <div class="card radius-10 w-100">
              <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                  <h6 class="mb-0">Clientes</h6>
                  <div class="dropdown options ms-auto">
                    <div class="dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown">
                      <ion-icon name="ellipsis-horizontal-outline"></ion-icon>
                    </div>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="javascript:;">Action</a></li>
                      <li><a class="dropdown-item" href="javascript:;">Another action</a></li>
                      <li><a class="dropdown-item" href="javascript:;">Something else here</a></li>
                    </ul>
                  </div>
                </div>
                <div class="row row-cols-1 row-cols-md-2 g-3 align-items-center">
                  <div class="col-lg-7 col-xl-7 col-xxl-7 order-2">
                    <div id="chart6"></div>
                  </div>
                  <div class="col-lg-5 col-xl-5 col-xxl-5">
                    <div class="">
                       <div class="mb-4">
                         <h2 class="mb-0"><?php echo $countcliente  ?></h2>
                         <p class="mb-0">Clientes activos</p>
                       </div>
                      <div class="d-flex align-items-start gap-3 mb-3">
                        <div class="widget-icon-small rounded bg-light-purple text-purple">
                          <ion-icon name="gift-outline"></ion-icon>
                        </div>
                        <div>
                          <p class="mb-1">Total Arriendos</p>
                          <p class="mb-0 h5"><?PHP ECHO $total_arriendo?></p>
                        </div>
                      </div>
                      <div class="d-flex align-items-start gap-3 mb-3">
                        <div class="widget-icon-small rounded bg-light-info text-info">
                          <ion-icon name="briefcase-outline"></ion-icon>
                        </div>
                        <div>
                          <p class="mb-1">Total Prestamos</p>
                          <p class="mb-0 h5"><?PHP ECHO $total_consignacion?></p>
                        </div>
                      </div>
                      <div class="d-flex align-items-start gap-3">
                        <div class="widget-icon-small rounded bg-light-orange text-orange">
                          <ion-icon name="book-outline"></ion-icon>
                        </div>
                        <div>
                          <p class="mb-1">Total Consignaciones</p>
                          <p class="mb-0 h5"><?PHP ECHO $total_prestamo?></p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <script type="text/javascript">
          /*document.addEventListener('DOMContentLoaded', function() {
              document.getElementById("SvgjsText1612").textContent = "Nuevo Título";
              document.getElementById("SvgjsText1613").textContent = "Nuevo Valor%";
          });*/
        </script>
          <!--<div class="col-12 col-lg-12 col-xl-6 d-flex">
            <div class="card radius-10 w-100">
              <div class="card-body">
                <div class="d-flex align-items-center mb-3">
                  <h6 class="mb-0">Sales By Country</h6>
                  <div class="dropdown options ms-auto">
                    <div class="dropdown-toggle dropdown-toggle-nocaret" data-bs-toggle="dropdown">
                      <ion-icon name="ellipsis-horizontal-outline" role="img" class="md hydrated"
                        aria-label="ellipsis horizontal outline"></ion-icon>
                    </div>
                    <ul class="dropdown-menu">
                      <li><a class="dropdown-item" href="#">Action</a></li>
                      <li><a class="dropdown-item" href="#">Another action</a></li>
                      <li><a class="dropdown-item" href="#">Something else here</a></li>
                    </ul>
                  </div>
                </div>
                <div class="table-responsive">
                  <table class="table table-borderless align-middle mb-0">
                    <tbody>
                      <tr>
                        <td>
                          <div class="country-icon">
                            <img src="assets/images/icons/india.png" alt="" width="32">
                          </div>
                        </td>
                        <td>
                          <div class="country-name h6 mb-0">India</div>
                        </td>
                        <td class="w-100">
                          <div class="progress flex-grow-1" style="height: 5px;">
                            <div class="progress-bar bg-gradient-info" role="progressbar" style="width: 82%;"></div>
                          </div>
                        </td>
                        <td>
                          <div class="percent-data">82%</div>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <div class="country-icon">
                            <img src="assets/images/icons/usa.png" alt="" width="32">
                          </div>
                        </td>
                        <td>
                          <div class="country-name h6 mb-0">USA</div>
                        </td>
                        <td class="w-100">
                          <div class="progress flex-grow-1" style="height: 5px;">
                            <div class="progress-bar bg-gradient-purple" role="progressbar" style="width: 70%;"></div>
                          </div>
                        </td>
                        <td>
                          <div class="percent-data">70%</div>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <div class="country-icon">
                            <img src="assets/images/icons/china.png" alt="" width="32">
                          </div>
                        </td>
                        <td>
                          <div class="country-name h6 mb-0">China</div>
                        </td>
                        <td class="w-100">
                          <div class="progress flex-grow-1" style="height: 5px;">
                            <div class="progress-bar bg-gradient-success" role="progressbar" style="width: 60%;"></div>
                          </div>
                        </td>
                        <td>
                          <div class="percent-data">60%</div>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <div class="country-icon">
                            <img src="assets/images/icons/russia.png" alt="" width="32">
                          </div>
                        </td>
                        <td>
                          <div class="country-name h6 mb-0">Russia</div>
                        </td>
                        <td class="w-100">
                          <div class="progress flex-grow-1" style="height: 5px;">
                            <div class="progress-bar bg-gradient-warning" role="progressbar" style="width: 45%;"></div>
                          </div>
                        </td>
                        <td>
                          <div class="percent-data">45%</div>
                        </td>
                      </tr>
                      <tr>
                        <td>
                          <div class="country-icon">
                            <img src="assets/images/icons/russia.png" alt="" width="32">
                          </div>
                        </td>
                        <td>
                          <div class="country-name h6 mb-0">Russia</div>
                        </td>
                        <td class="w-100">
                          <div class="progress flex-grow-1" style="height: 5px;">
                            <div class="progress-bar bg-gradient-danger" role="progressbar" style="width: 30%;"></div>
                          </div>
                        </td>
                        <td>
                          <div class="percent-data">30%</div>
                        </td>
                      </tr>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>-->
        </div>
        <!--end row-->



        <div class="card radius-10 w-100">
          <div class="card-body">
            <div class="d-flex align-items-center">
              <h6 class="mb-0">Top mejores 6 Clientes</h6>
              <div class="fs-5 ms-auto dropdown">
                <div class="dropdown-toggle dropdown-toggle-nocaret cursor-pointer" data-bs-toggle="dropdown"><i
                    class="bi bi-three-dots"></i></div>
                <ul class="dropdown-menu">
                  <li><a class="dropdown-item" href="#">Action</a></li>
                  <li><a class="dropdown-item" href="#">Another action</a></li>
                  <li>
                    <hr class="dropdown-divider">
                  </li>
                  <li><a class="dropdown-item" href="#">Something else here</a></li>
                </ul>
              </div>
            </div>
            <div class="table-responsive mt-2">
              <table class="table align-middle mb-0">
                <thead class="table-light">
                  <tr>
                    <th>Tipo</th>
                    <th>Cliente</th>
                    <th>Teléfono</th>
                    <th>Correo</th>
                    <th>Dirección</th>
                  </tr>
                </thead>
                <tbody>

                  <?php                                            

                                            while ($row_topclient = mysqli_fetch_assoc($result_mejores_clientes)) {
                                              $id_client = $row_topclient['id_cliente'];
                                              $sql_rut_cliente = "SELECT * FROM cliente WHERE estado = 'Activo' AND id_cliente = '$id_client'";
                                              $query_ruts_cliente = mysqli_query($con, $sql_rut_cliente);
                                              $row_cliente2 = mysqli_fetch_assoc($query_ruts_cliente);
                                        ?>
                                        <tr>
                                            
                                            <td><?php echo $row_cliente2['tipo_cliente'] ?></td>
                                            <td><?php 
                                            if ($row_cliente2['nombre'] != "") {
                                                echo $row_cliente2['nombre']." ".$row_cliente2['apellido'];
                                            } else {
                                                echo $row_cliente2['razon_social'];
                                            } ?></td>
                                            <td><?php echo $row_cliente2['mail'] ?></td>  
                                            <td><?php echo $row_cliente2['telefono'] ?></td>
                                            <td><?php echo $row_cliente2['direccion'] ?></td>                                       
                                                                                       
                                        </tr>
                                        <?php  
                                        } mysqli_free_result($result_mejores_clientes);
                                        ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
      <!-- end page content-->
    </div>
    <!--end page content wrapper-->
    <script>
      /*document.addEventListener('DOMContentLoaded', function () {
          // Opciones del gráfico
          var options = {
              chart: {
                  type: 'line', // Tipo de gráfico (puede ser 'bar', 'area', 'line', etc.)
                  height: 300, // Altura del gráfico
                  toolbar: {
                      show: false // Ocultar barra de herramientas del gráfico
                  }
              },
              series: [{
                  name: 'Ganancias', // Nombre de la serie de datos
                  data: [856, 910, 980, 1020, 1140, 1250, 1350] // Datos de ejemplo
              }],
              xaxis: {
                  categories: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul'] // Meses de ejemplo
              },
              colors: ['#008FFB'], // Color de la línea del gráfico
              stroke: {
                  width: 2
              },
              dataLabels: {
                  enabled: false // Ocultar etiquetas de datos
              },
              grid: {
                  show: true
              },
              markers: {
                  size: 5, // Tamaño de los marcadores
                  colors: ['#008FFB'],
                  strokeColors: '#fff',
                  strokeWidth: 2
              }
          };

          // Inicializar el gráfico en el div con id="chart3"
          var chart = new ApexCharts(document.querySelector("#chart3"), options);
          chart.render(); // Renderizar el gráfico
      });*/
      </script>
      <script>
        document.addEventListener('DOMContentLoaded', function () {
            // Opciones del nuevo gráfico
            /*var ganancias_enero = <?php echo str_replace('.', '', $total_caja_ventas); ?>;  // Remueve puntos de miles
            // Asegura que el valor sea numérico
            ganancias_enero = parseInt(ganancias_enero, 10);*/

            var totalesPorMes = <?php echo json_encode($totales_por_mes); ?>;
            // Extraer los valores para el gráfico
            var añoActual = new Date().getFullYear();

            var datos = [
                totalesPorMes[añoActual + '-01'] || 0, // Enero
                totalesPorMes[añoActual + '-02'] || 0, // Febrero
                totalesPorMes[añoActual + '-03'] || 0, // Marzo
                totalesPorMes[añoActual + '-04'] || 0, // Abril
                totalesPorMes[añoActual + '-05'] || 0, // Mayo
                totalesPorMes[añoActual + '-06'] || 0, // Junio
                totalesPorMes[añoActual + '-07'] || 0, // Julio
                totalesPorMes[añoActual + '-08'] || 0, // Agosto
                totalesPorMes[añoActual + '-09'] || 0, // Septiembre
                totalesPorMes[añoActual + '-10'] || 0, // Octubre
                totalesPorMes[añoActual + '-11'] || 0, // Noviembre
                totalesPorMes[añoActual + '-12'] || 0  // Diciembre
            ];

            var options = {
                chart: {
                    type: 'line', // Tipo de gráfico
                    height: 300, // Altura del gráfico
                    toolbar: {
                        show: false // Ocultar barra de herramientas del gráfico
                    }
                },
                series: [{
                    name: 'Ventas',
                    data: datos
                }],
                xaxis: {
                    categories: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sept', 'Oct', 'Nov', 'Dic'] // Categorías de eje X
                },
                colors: ['#008FFB'], // Color de la línea del gráfico
                stroke: {
                    width: 2
                },
                dataLabels: {
                    enabled: false // Ocultar etiquetas de datos
                },
                grid: {
                    show: true
                },
                markers: {
                    size: 5, // Tamaño de los marcadores
                    colors: ['#008FFB'], // Color de los marcadores
                    strokeColors: '#fff',
                    strokeWidth: 2
                }

            };

            // Inicializar el gráfico en el div con id="chart20"
            var chart20 = new ApexCharts(document.querySelector("#chart20"), options);
            chart20.render(); // Renderizar el gráfico
        });
      </script>

    <!--start footer-->
    <footer class="footer">
      <div class="footer-text">
        NEOTOP TODOS LOS DERECHOS RESERVADOS. DESARROLLADO POR VECTOR WEB 🖥️
      </div>
    </footer>
    <!--end footer-->


    <!--Start Back To Top Button-->
    <a href="javaScript:;" class="back-to-top">
      <ion-icon name="arrow-up-outline"></ion-icon>
    </a>
    <!--End Back To Top Button-->



    <!--start overlay-->
    <div class="overlay nav-toggle-icon"></div>
    <!--end overlay-->

  </div>
  <!--end wrapper-->


  <!-- JS Files-->
  <script src="assets/js/jquery.min.js"></script>
  <script src="assets/plugins/simplebar/js/simplebar.min.js"></script>
  <script src="assets/plugins/metismenu/js/metisMenu.min.js"></script>
  <script src="assets/js/bootstrap.bundle.min.js"></script>
  <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
  <!--plugins-->
  <script src="assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
  <!-- PLUGIN APEXCHART ES EL GRAFICO DE INFORME DE GANANCIAS DEL DASHBOARD -->
  <script src="assets/plugins/apexcharts-bundle/js/apexcharts.min.js"></script>
  <script src="assets/plugins/easyPieChart/jquery.easypiechart.js"></script>
  <script src="assets/plugins/chartjs/chart.min.js"></script>
  <script src="assets/js/index.js"></script>
  <!-- Main JS-->
  <script src="assets/js/main.js"></script>


</body>

</html>