<?php
	//include("conexioncrud.php");
	include("datos_sistema.php"); 
	// ID del usuario actual (obtenlo desde la sesión o como necesites)
	// $usuario_id = $_SESSION['usuario_id']; iduser de datos_sistema.php contiene el id del usuario
	// Consulta para obtener las notificaciones no leídas
	$query = "SELECT * FROM notificaciones WHERE usuario_id = ? AND leido = 0 ORDER BY fecha_creacion DESC";
	$stmt = $con->prepare($query);
	$stmt->bind_param("i", $iduser);
	$stmt->execute();
	$result = $stmt->get_result();

	// Array para almacenar las notificaciones
	$notificaciones = [];
	while ($row = $result->fetch_assoc()) {
	    $notificaciones[] = [
	        'titulo' => $row['titulo'],
	        'mensaje' => $row['mensaje'],
	        'icono' => $row['icono'],
	        'icono_color' => 'primary', // Ajustar según el tipo de notificación
	        'tiempo' => tiempo_transcurrido($row['fecha_creacion']), // Función para calcular el tiempo transcurrido
	        'url_destino' => $row['url_destino']
	    ];
	}

	// Consulta para contar la cantidad de notificaciones no leídas
	$query_count = "SELECT COUNT(*) as unread_count FROM notificaciones WHERE usuario_id = ? AND leido = 0";
	$stmt_count = $con->prepare($query_count);
	$stmt_count->bind_param("i", $iduser);
	$stmt_count->execute();
	$result_count = $stmt_count->get_result();
	$row_count = $result_count->fetch_assoc();
	$unread_count = $row_count['unread_count'];

	// Retornar las notificaciones y la cantidad de no leídas
	echo json_encode([
	    'unread_count' => $unread_count,
	    'notifications' => $notificaciones
	]);

	// Función para calcular el tiempo transcurrido
	function tiempo_transcurrido($fecha) {
	    $diff = (time() - 10800) - strtotime($fecha);
	    if ($diff < 60) {
	        return "Hace $diff seg";
	    } elseif ($diff < 3600) {
	        return "Hace ".floor($diff / 60) . " min";
	    } elseif ($diff < 86400) {
	        return "Hace ".floor($diff / 3600) . " hrs";
	    } else {
	        return "Hace ".floor($diff / 86400) . " días";
	    }
	}


?>
