<?php
// Conectar a la base de datos
include('datos_sistema.php'); // Asegúrate de ajustar este archivo según tu conexión

// Verificar que el id_matricula esté presente en el GET
if (isset($_GET['id_matricula'])) {
    $id_matricula = $_GET['id_matricula'];

    // Primero, obtener el id_alumno desde la tabla matriculas
    $sql_select = "SELECT id_alumno FROM matriculas WHERE id_matricula = ?";
    $stmt = $con->prepare($sql_select);
    $stmt->bind_param("i", $id_matricula); // "i" para tipo entero
    $stmt->execute();
    $result = $stmt->get_result();

    // Verificar si se encontró la matrícula
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $id_alumno = $row['id_alumno'];

        // Actualizar la tabla matriculas, poner pendiente en 0
        $sql_update_matricula = "UPDATE matriculas SET pendiente = 0 WHERE id_matricula = ?";
        $stmt_update_matricula = $con->prepare($sql_update_matricula);
        $stmt_update_matricula->bind_param("i", $id_matricula);
        $stmt_update_matricula->execute();

        // Actualizar la tabla alumnos, poner matricula_pagada en 'Si'
        $sql_update_alumno = "UPDATE alumnos SET matricula_pagada = 'Si' WHERE id_alumno = ?";
        $stmt_update_alumno = $con->prepare($sql_update_alumno);
        $stmt_update_alumno->bind_param("i", $id_alumno);
        $stmt_update_alumno->execute();

        // Comprobar si ambas consultas se ejecutaron correctamente
        if ($stmt_update_matricula->affected_rows > 0 && $stmt_update_alumno->affected_rows > 0) {
            $succ="cuota2";
            header("Location:tabla_matriculas.php?client=$succ");
        } else {
            echo "Hubo un problema al actualizar los datos.";
        }
    } else {
        echo "Matrícula no encontrada.";
    }
} else {
    echo "ID de matrícula no especificado.";
}

// Cerrar las conexiones
$stmt->close();
$stmt_update_matricula->close();
$stmt_update_alumno->close();
$con->close();
?>